/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceProcessConnector;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceBase
implements JSLanguageService,
Disposable {
    protected static final long ALIVE_CHECK_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    protected static final long ALIVE_CHECK_LONG_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    protected static final int ALIVE_CHECK_COUNT_BEFORE_LONG_WAITING = 5;
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final JSLanguageServiceToolWindowManager myToolWindowManager;
    protected final AtomicLong myFailCount;
    @NotNull
    protected final Alarm myCheckAliveAlarm;
    @NotNull
    protected volatile ThreeState myCanStartProcess;
    @NotNull
    protected volatile JSLanguageServiceQueue.ServiceInfoReporter myDefaultReporter;
    @Nullable
    private volatile JSLanguageServiceQueue myService;
    @NotNull
    private final Object myLock;
    private final NullableLazyValue<Void> myInitialization;
    @Nullable
    protected final JSLanguageServiceQueue.ProcessConnector myProcessConnector;

    public JSLanguageServiceBase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "<init>"));
        }
        this.myFailCount = new AtomicLong();
        this.myCanStartProcess = ThreeState.UNSURE;
        this.myDefaultReporter = JSLanguageServiceQueue.DEFAULT_REPORTER;
        this.myLock = new Object();
        this.myInitialization = NullableLazyValue.createValue(() -> {
            this.initializeOnce();
            return null;
        });
        this.myProject = project;
        this.myToolWindowManager = this.createToolWindow(project);
        if (this.myToolWindowManager != null) {
            this.myDefaultReporter = new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, false);
        }
        this.myCheckAliveAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProcessConnector = this.createProcessConnector(this.myToolWindowManager);
    }

    @Nullable
    protected JSLanguageServiceQueue.ProcessConnector createProcessConnector(@Nullable JSLanguageServiceToolWindowManager manager) {
        if (manager == null) {
            return null;
        }
        return new JSLanguageServiceProcessConnector("Console", manager);
    }

    protected void initializeOnce() {
        this.createAliveChecker().run();
        this.initToolWindow();
    }

    public final void initialize() {
        ReadAction.run(() -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myInitialization.getValue();
            }
        });
    }

    @NotNull
    protected final Runnable createAliveChecker() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JSLanguageServiceBase.this.checkAlive(this);
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "createAliveChecker"));
        }
        return runnable;
    }

    @NotNull
    protected String getProcessName() {
        if ("Language" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "getProcessName"));
        }
        return "Language";
    }

    @Nullable
    protected abstract JSLanguageServiceQueue createLanguageServiceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkAlive(@NotNull Runnable self) {
        if (self == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "self", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "checkAlive"));
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        JSLanguageServiceQueue serviceQueue = this.myService;
        if (serviceQueue != null) {
            Object object = this.myLock;
            synchronized (object) {
                serviceQueue = this.myService;
                if (serviceQueue != null) {
                    JSLanguageServiceQueue.State state = serviceQueue.getState();
                    if (state == JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT) {
                        this.myFailCount.incrementAndGet();
                        ApplicationManager.getApplication().invokeLater(() -> this.terminateStartedProcessImpl(false));
                    } else if (state == JSLanguageServiceQueue.State.STARTED) {
                        this.myFailCount.set(0L);
                    }
                }
            }
        } else if (!this.checkCanUseService()) {
            if (this.myCanStartProcess == ThreeState.NO) {
                this.myFailCount.incrementAndGet();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.initializeServiceQueue());
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        long timeout = ALIVE_CHECK_TIMEOUT;
        if (this.myFailCount.get() > 5L) {
            timeout = ALIVE_CHECK_LONG_TIMEOUT;
        }
        this.myCheckAliveAlarm.addRequest(self, timeout);
    }

    protected abstract boolean needInitToolWindow();

    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        return null;
    }

    @NotNull
    public final JSLanguageServiceQueue.ServiceInfoReporter getDefaultReporter() {
        JSLanguageServiceQueue.ServiceInfoReporter serviceInfoReporter = this.myDefaultReporter;
        if (serviceInfoReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "getDefaultReporter"));
        }
        return serviceInfoReporter;
    }

    @Nullable
    public final JSLanguageServiceToolWindowManager getToolWindowManager() {
        return this.myToolWindowManager;
    }

    public final boolean isServiceCreated() {
        return this.myService != null;
    }

    @Nullable
    protected final JSLanguageServiceQueue getProcess() {
        JSLanguageServiceQueue toReturn = this.myService;
        if (toReturn != null) {
            return toReturn;
        }
        return (JSLanguageServiceQueue)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return this.computeProcessUnderLocks();
            }
        });
    }

    @Nullable
    protected final JSLanguageServiceQueue computeProcessUnderLocks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue service = this.myService;
        if (service == null) {
            this.myInitialization.getValue();
            this.myService = service = this.createLanguageServiceQueue();
        }
        return service;
    }

    protected final void initializeServiceQueue() {
        this.getProcess();
    }

    @Nullable
    public final <T> Future<T> sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "sendCommand"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "sendCommand"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        return process.execute(command, processor);
    }

    public final void sendCommand(@NotNull JSLanguageServiceSimpleCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "sendCommand"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null);
    }

    public final void setDefaultReporter(@NotNull JSLanguageServiceQueue.ServiceInfoReporter defaultReporter) {
        if (defaultReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultReporter", "com/intellij/lang/javascript/service/JSLanguageServiceBase", "setDefaultReporter"));
        }
        this.myDefaultReporter = defaultReporter;
    }

    protected JSLanguageServiceQueue getLSProcess() {
        return this.myService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLanguageService(@Nullable JSLanguageServiceQueue service) {
        Object object = this.myLock;
        synchronized (object) {
            this.myService = service;
        }
    }

    public final void terminateStartedProcess(boolean recreateToolWindow) {
        this.resetState();
        this.terminateStartedProcessImpl(recreateToolWindow);
    }

    protected void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed() || !this.myProject.isOpen() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myToolWindowManager.lazyInit((Condition<JSLanguageServiceToolWindowManager>)((Condition)el -> this.needInitToolWindow()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateStartedProcessImpl(boolean recreateToolWindow) {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceToolWindowManager manager = this.myToolWindowManager;
            if (this.myProcessConnector != null && this.myProcessConnector.isConnected()) {
                this.myProcessConnector.disconnectFromProcessHandler();
                JSLanguageServiceQueue service = this.myService;
                if (manager != null && service != null && service.getState() == JSLanguageServiceQueue.State.STARTED) {
                    manager.cleanErrorsPanel();
                }
            }
            if (manager != null && recreateToolWindow) {
                manager.resetToolWindow();
            }
            this.disposeQueue();
            this.initToolWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeQueue() {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceQueue service = this.myService;
            if (service != null) {
                this.myService = null;
                this.myCanStartProcess = ThreeState.UNSURE;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    if (service.getState() != JSLanguageServiceQueue.State.DISPOSED) {
                        Disposer.dispose((Disposable)service);
                    }
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (service.getState() != JSLanguageServiceQueue.State.DISPOSED) {
                            Disposer.dispose((Disposable)service);
                        }
                    });
                }
            }
        }
    }

    @Nullable
    public abstract Future<Boolean> update(JSLanguageServiceUpdateContext var1);

    public boolean checkCanUseService() {
        return this.myCanStartProcess != ThreeState.NO && this.myFailCount.get() < 5L;
    }

    protected void resetState() {
        this.myFailCount.set(0L);
        this.myCanStartProcess = ThreeState.UNSURE;
    }

    public void dispose() {
        JSLanguageServiceQueue queue = this.myService;
        if (queue != null) {
            Disposer.dispose((Disposable)queue);
        }
    }
}

