/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceUtil {
    public static final long TIMEOUT_MILLS = TimeUnit.SECONDS.toMillis(20L);
    public static final long QUOTA_MILLS = 10L;

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMills, quotaMills, indicator, true);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator, boolean cancelFutureIfTimeout) {
        if (future == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            JSLanguageServiceQueue.LOGGER.error("Await future on EDT may cause a deadlock");
        }
        try {
            if (future.isDone()) {
                return future.get();
            }
            for (long totalWait = timeoutMills; totalWait > 0L; totalWait -= quotaMills) {
                try {
                    return future.get(quotaMills, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (indicator == null) {
                        ProgressManager.checkCanceled();
                        continue;
                    }
                    indicator.checkCanceled();
                    continue;
                }
            }
            if (future.isDone()) {
                return future.get();
            }
            if (cancelFutureIfTimeout) {
                future.cancel(false);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, int line, int column, int endLine, int endColumn) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getElementInfo"));
        }
        try {
            int lineStartOffset;
            if (line < 0 || line >= document.getLineCount()) {
                return null;
            }
            int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if ((errorStartOffset += column) > lineEndOffset) {
                return null;
            }
            PsiElement element = null;
            TextRange range = null;
            if (endLine < 0 && file != null) {
                element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
            } else {
                if (endLine < 0 || endLine >= document.getLineCount()) {
                    return null;
                }
                int errorEndOffset = document.getLineStartOffset(endLine);
                int lineToEndOffset = document.getLineEndOffset(endLine);
                if ((errorEndOffset += endColumn) > lineToEndOffset) {
                    return null;
                }
                range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
            }
            return new PsiElementInfo(element, range);
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static File getPluginStarterDirectory() {
        File file = TypeScriptUtil.getTypeScriptCompilerFolderFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getPluginStarterDirectory"));
        }
        return file;
    }

    public static class PsiElementInfo {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final TextRange myRange;

        public PsiElementInfo(@Nullable PsiElement element, @Nullable TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }
    }
}

