/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface JSLanguageServiceFilter {
    public static final ExtensionPointName<JSLanguageServiceFilter> EP = ExtensionPointName.create((String)"JavaScript.LanguageServiceFilter");

    public static boolean checkAvailable(Project project, @NotNull JSLanguageService service, @NotNull VirtualFile file) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceFilter", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceFilter", "checkAvailable"));
        }
        if (!Extensions.getArea((AreaInstance)project).hasExtensionPoint(EP.getName())) {
            return false;
        }
        JSLanguageServiceFilter[] filters = (JSLanguageServiceFilter[])EP.getExtensions((AreaInstance)project);
        if (filters.length == 0) {
            return true;
        }
        return Arrays.stream(filters).allMatch(el -> {
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceFilter", "lambda$checkAvailable$0"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceFilter", "lambda$checkAvailable$0"));
            }
            return el.isAvailable(project, service, file);
        });
    }

    public boolean isAvailable(Project var1, @NotNull JSLanguageService var2, @NotNull VirtualFile var3);
}

