/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.macro.Macro;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceNodeStdProtocolBase
implements JSLanguageServiceProtocol {
    protected static final String ANSWER_READY = "ready";
    protected static final String ANSWER_ERROR = "error";
    @NotNull
    protected final Project myProject;
    @Nullable
    protected volatile String myInitializeError;
    protected final long mySessionId;
    @NotNull
    private final Consumer<JsonObject> myInitialStateConsumer;
    @Nullable
    private OutputStream myProcessInput;
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks;

    public JSLanguageServiceNodeStdProtocolBase(@NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "<init>"));
        }
        if (readyConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readyConsumer", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "<init>"));
        }
        this.mySessionId = System.currentTimeMillis();
        this.myCallbacks = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myInitialStateConsumer = readyConsumer;
    }

    @Override
    @Nullable
    public final String getInitializeError() {
        return this.myInitializeError;
    }

    protected boolean waitingReadyNotification(@NotNull OSProcessHandler processHandler, @NotNull ThrowableRunnable<Exception> action, final @NotNull ReadyChecker checker) throws Exception {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "waitingReadyNotification"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "waitingReadyNotification"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "waitingReadyNotification"));
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result = new Ref((Object)false);
        ProcessAdapter listener = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                checker.check(event, outputType, (Ref<Boolean>)result, countDownLatch);
            }

            public void processTerminated(ProcessEvent event) {
                countDownLatch.countDown();
            }
        };
        processHandler.addProcessListener((ProcessListener)listener);
        action.run();
        try {
            JSLanguageServiceQueue.LOGGER.debug("Start waiting for ready start");
            countDownLatch.await(30L, TimeUnit.SECONDS);
            JSLanguageServiceQueue.LOGGER.debug("End waiting for process starting. Result " + result.get());
        }
        catch (InterruptedException e) {
            JSLanguageServiceQueue.LOGGER.debug("Process interrupted while waiting ready state");
        }
        processHandler.removeProcessListener((ProcessListener)listener);
        return (Boolean)result.get();
    }

    @Nullable
    protected final GeneralCommandLine createCommandLine() throws Macro.ExecutionCancelledException {
        String interpreter = this.getNodeInterpreter();
        if (StringUtil.isEmptyOrSpaces((String)interpreter)) {
            this.myInitializeError = JSBundle.message((String)"javascript.service.node.error", (Object[])new Object[0]);
            throw new RuntimeException(this.myInitializeError);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreter});
        this.addNodeProcessAdditionalArguments(commandLine);
        File file = new File(this.getEntryPointFolder(), this.getEntryPointFile());
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file.getAbsolutePath());
        }
        commandLine.withWorkDirectory(this.myProject.getBasePath());
        commandLine.addParameter(file.getAbsolutePath());
        commandLine.addParameter(this.getSessionIdParam());
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Commandline " + commandLine.toString());
        }
        return commandLine;
    }

    @Nullable
    protected abstract String getNodeInterpreter();

    protected void addNodeProcessAdditionalArguments(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "addNodeProcessAdditionalArguments"));
        }
    }

    @NotNull
    protected String getEntryPointFile() {
        if ("js-language-service.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "getEntryPointFile"));
        }
        return "js-language-service.js";
    }

    protected final String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    protected File getEntryPointFolder() {
        return JSLanguageServiceUtil.getPluginStarterDirectory();
    }

    @Override
    public void cancelCommand(Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        this.myCallbacks.remove(cancellationToken);
    }

    @NotNull
    protected final String toSystemCommand(String command) {
        String string = this.mySessionId + " " + command;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "toSystemCommand"));
        }
        return string;
    }

    @Nullable
    protected final OSProcessHandler createProcessHandlerAndWaitInitialization(GeneralCommandLine line) throws Exception {
        if (line == null) {
            JSLanguageServiceQueue.LOGGER.debug("Cannot create command line for language service ");
            return null;
        }
        OSProcessHandler processHandler = this.createProcessHandler(line);
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ((OSProcessHandler)processHandler).startNotify()), this::checkReadyCommand)) {
                processHandler.destroyProcess();
                return null;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        return processHandler;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(GeneralCommandLine line) throws ExecutionException {
        OSProcessHandler oSProcessHandler = new OSProcessHandler(line){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                final BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                BaseOutputReader.Options options2 = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return options.policy();
                    }

                    public boolean splitToLines() {
                        return options.splitToLines();
                    }

                    public boolean sendIncompleteLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
                if (options2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$2", "readerOptions"));
                }
                return options2;
            }
        };
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "createProcessHandler"));
        }
        return oSProcessHandler;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = this.createCommandLine();
        if (line == null) {
            return null;
        }
        OSProcessHandler processHandler = this.createProcessHandlerAndWaitInitialization(line);
        if (processHandler == null) {
            return null;
        }
        JSLanguageServiceQueue.LOGGER.debug("Language service was started. Start initialization of typescript plugin");
        this.myProcessInput = processHandler.getProcessInput();
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)this::sendInitialState), (event, outputType, result, countDownLatch) -> {
                block8: {
                    if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                        String text = StringUtil.trim((String)event.getText());
                        if (text.startsWith("{") && text.endsWith("}")) {
                            JsonElement answer = new JsonParser().parse(text);
                            JsonObject answerAsJsonObject = answer.getAsJsonObject();
                            try {
                                JsonPrimitive success = answerAsJsonObject.getAsJsonPrimitive("success");
                                JsonPrimitive error = answerAsJsonObject.getAsJsonPrimitive(ANSWER_ERROR);
                                if (success.getAsBoolean()) {
                                    result.set((Object)true);
                                    countDownLatch.countDown();
                                    this.myInitialStateConsumer.consume((Object)answerAsJsonObject);
                                    break block8;
                                }
                                String errorText = StringUtil.notNullize((String)error.getAsString());
                                JsonPrimitive stack = answerAsJsonObject.getAsJsonPrimitive("stack");
                                JSLanguageServiceQueue.LOGGER.debug("Error initialization " + errorText + "\n" + (stack == null ? "" : stack.getAsString()));
                                this.myInitializeError = errorText;
                                countDownLatch.countDown();
                            }
                            catch (Exception e) {
                                JSLanguageServiceQueue.LOGGER.debug("Error initialization " + e.getMessage());
                                this.myInitializeError = "Cannot parse service initialization answer " + text + "\n";
                            }
                        } else {
                            JSLanguageServiceQueue.LOGGER.warn("Expected json answer: " + event.getText());
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        JSLanguageServiceQueue.LOGGER.debug("Starting language service output error: " + event.getText());
                    }
                }
            })) {
                processHandler.destroyProcess();
                return null;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text;
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text = event.getText()))) {
                    text = StringUtil.trim((String)text);
                    JSLanguageServiceNodeStdProtocolBase.this.processText(text);
                }
            }
        });
        return processHandler;
    }

    private void processText(String text) {
        if (text.startsWith("{") && text.endsWith("}")) {
            JSLanguageServiceAnswer answer = new JSLanguageServiceAnswer(text);
            Integer seq = answer.getSeq();
            if (seq != null) {
                JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(seq);
                if (consumer != null) {
                    if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                        JSLanguageServiceQueue.LOGGER.debug("Pass request " + seq + " to consumer");
                    }
                    consumer.consume(answer);
                } else if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.LOGGER.debug("No callback for seq: " + text);
                }
            } else if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.LOGGER.debug("No sequence number, skip request: " + text);
            }
        }
    }

    private void sendInitialState() throws Exception {
        JSLanguageServiceInitialState initialState = this.createState();
        String state = JSLanguageServiceQueue.GSON.toJson((Object)initialState);
        JSLanguageServiceQueue.LOGGER.debug("Send state to service: " + state);
        this.write(state + "\n");
    }

    protected abstract JSLanguageServiceInitialState createState();

    protected final void checkReadyCommand(ProcessEvent event, Key outputType, Ref<Boolean> result, CountDownLatch countDownLatch) {
        if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
            String prefix;
            JSLanguageServiceQueue.LOGGER.debug("Starting language service output: " + event.getText());
            String text = event.getText().trim();
            if (this.toSystemCommand(ANSWER_READY).equals(text)) {
                result.set((Object)true);
                countDownLatch.countDown();
            }
            if (text.startsWith(prefix = this.toSystemCommand(ANSWER_ERROR))) {
                JSLanguageServiceQueue.LOGGER.debug("Error initialization " + text.substring(prefix.length()));
                this.myInitializeError = text.substring(prefix.length());
                countDownLatch.countDown();
            }
        } else if (outputType == ProcessOutputTypes.STDERR) {
            JSLanguageServiceQueue.LOGGER.debug("Starting language service output error: " + event.getText());
        }
    }

    protected void write(@NotNull String data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase", "write"));
        }
        if (this.myProcessInput != null) {
            this.myProcessInput.write(data.getBytes(CharsetToolkit.UTF8_CHARSET));
            this.myProcessInput.flush();
        }
    }

    protected static interface ReadyChecker {
        public void check(@NotNull ProcessEvent var1, @NotNull Key var2, @NotNull Ref<Boolean> var3, @NotNull CountDownLatch var4);
    }
}

