/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class JSLanguageServiceConsole
implements Disposable {
    @NotNull
    private final ContentImpl myConsoleContent;
    @NotNull
    private final ConsoleView myConsoleView;
    @NotNull
    private final ToolWindow myToolWindow;
    private volatile boolean myDisposed;

    JSLanguageServiceConsole(@NotNull String consoleId, @NotNull ToolWindow toolWindow, @NotNull ConsoleViewImpl console, @NotNull JSConsoleViewPanel panel) {
        if (consoleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceConsole", "<init>"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/lang/javascript/service/ui/JSLanguageServiceConsole", "<init>"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/lang/javascript/service/ui/JSLanguageServiceConsole", "<init>"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/lang/javascript/service/ui/JSLanguageServiceConsole", "<init>"));
        }
        this.myDisposed = false;
        this.myConsoleContent = new ContentImpl((JComponent)panel, consoleId, false);
        this.myConsoleView = console;
        this.myToolWindow = toolWindow;
        this.myToolWindow.getContentManager().addContent((Content)this.myConsoleContent);
    }

    public void print(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/service/ui/JSLanguageServiceConsole", "print"));
        }
        if (!this.myDisposed) {
            this.myConsoleView.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public synchronized void dispose() {
        if (this.myDisposed) {
            return;
        }
        if (!this.myToolWindow.isDisposed()) {
            this.myToolWindow.getContentManager().removeContent((Content)this.myConsoleContent, true);
        } else {
            Disposer.dispose((Disposable)this.myConsoleContent);
        }
        Disposer.dispose((Disposable)this.myConsoleView);
        this.myDisposed = true;
    }
}

