/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

class FlowJSConfigurationPanel {
    private JPanel myPanel;
    private TextFieldWithHistoryWithBrowseButton myFlowExecutableCombobox;
    private JCheckBox myTypeChecking;
    private JCheckBox myOtherServices;
    private JCheckBox myFlowResolveCheckBox;

    public FlowJSConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel", "<init>"));
        }
        this.myFlowExecutableCombobox = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"js.flow.settings.executable.dialog.title", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel", "lambda$new$0"));
            }
            return FlowJSServerService.calcPossibleFlowExecutableFiles(project);
        });
        ((TextFieldWithHistory)this.myFlowExecutableCombobox.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FlowJSConfigurationPanel.this.updateEnabled();
            }
        });
        this.myTypeChecking = new JBCheckBox(JSBundle.message((String)"js.flow.enable.type.checking", (Object[])new Object[0]), true);
        this.myTypeChecking.addChangeListener(e -> this.updateEnabled());
        this.myOtherServices = new JBCheckBox(JSBundle.message((String)"js.flow.enable.other.services", (Object[])new Object[0]), true);
        String html = "<html><body>" + JSBundle.message((String)"js.flow.enable.resolve", (Object[])new Object[0]) + "<div style='font-size: medium; color: #" + ColorUtil.toHex((Color)UIUtil.getLabelDisabledForeground()) + "'>" + JSBundle.message((String)"js.flow.enable.resolve.warning", (Object[])new Object[0]) + "</div></body></html>";
        this.myFlowResolveCheckBox = new JBCheckBox(html, false);
        this.myFlowResolveCheckBox.setToolTipText(JSBundle.message((String)"js.flow.enable.resolve.description", (Object[])new Object[0]));
        this.myFlowResolveCheckBox.setVerticalAlignment(1);
        this.myFlowResolveCheckBox.setVerticalTextPosition(1);
        this.myPanel = FormBuilder.createFormBuilder().setVerticalGap(JBUI.scale((int)8)).addSeparator().addLabeledComponent(JSBundle.message((String)"js.flow.settings.executable.label", (Object[])new Object[0]), (JComponent)this.myFlowExecutableCombobox).addComponent((JComponent)new JBLabel(JSBundle.message((String)"js.flow.services.label", (Object[])new Object[0]))).addComponent((JComponent)this.myTypeChecking).addComponent((JComponent)this.myOtherServices).addComponent((JComponent)this.myFlowResolveCheckBox).getPanel();
        this.myPanel.setVisible(false);
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    public FlowJSSettings getFlowSettings() {
        return new FlowJSSettings.Builder().setFlowExecutablePath(this.myFlowExecutableCombobox.getText()).setTypeCheckingEnabled(this.myTypeChecking.isSelected()).setOtherServicesEnabled(this.myOtherServices.isSelected()).setFlowResolveEnable(this.myFlowResolveCheckBox.isSelected()).build();
    }

    public void setFlowSettings(@NotNull FlowJSSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel", "setFlowSettings"));
        }
        String path = settings.getFlowExecutablePath();
        this.myFlowExecutableCombobox.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)path));
        if (!path.isEmpty()) {
            this.myTypeChecking.setSelected(settings.isTypeCheckingEnabled());
            this.myFlowResolveCheckBox.setSelected(settings.getFlowResolveEnable());
            this.myOtherServices.setSelected(settings.isOtherServicesEnabled());
        }
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean pathIsEmpty = this.myFlowExecutableCombobox.getText().isEmpty();
        boolean typeCheckSelected = this.myTypeChecking.isSelected();
        this.myTypeChecking.setEnabled(!pathIsEmpty);
        this.myOtherServices.setEnabled(!pathIsEmpty && typeCheckSelected);
        this.myFlowResolveCheckBox.setEnabled(!pathIsEmpty && typeCheckSelected);
    }
}

