/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSForInPostfixTemplate
extends StringBasedPostfixTemplate {
    public JSForInPostfixTemplate() {
        super("itin", "for(var obj in expr)", JSPostfixTemplateUtils.selectorTopmost());
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSForInPostfixTemplate", "getTemplateString"));
        }
        String prefix = JSChangeUtil.getVariablePrefix(element);
        return "for (" + prefix + " $name$ in $expr$) {\n$END$\n}";
    }

    public void setVariables(@NotNull Template template, @NotNull PsiElement element) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/lang/javascript/template/postfix/JSForInPostfixTemplate", "setVariables"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSForInPostfixTemplate", "setVariables"));
        }
        MacroCallNode name = new MacroCallNode((Macro)new JSSuggestVariableNameMacro());
        template.addVariable("name", (Expression)name, (Expression)name, true);
    }
}

