/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSForOfPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final Condition<PsiElement> ARRAY_TYPE = element -> {
        if (!JSPostfixTemplateUtils.DEFAULT_FILTER.value(element)) {
            return false;
        }
        if (element instanceof JSExpression) {
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)element);
            JSType valuableType = JSTypeUtils.getValuableType(type);
            return valuableType != null && JSTypeUtils.isArrayType(valuableType);
        }
        return false;
    };

    public JSForOfPostfixTemplate() {
        super("forof", "for (let obj of expr)", JSPostfixTemplateUtils.selectorWithFeature(JSPostfixTemplateUtils.selectorTopmost(ARRAY_TYPE), JSLanguageFeature.FOR_OF, null));
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSForOfPostfixTemplate", "getTemplateString"));
        }
        String prefix = JSChangeUtil.getVariablePrefix(element);
        return "for (" + prefix + " $name$ of $expr$) {\n$END$\n}";
    }

    public void setVariables(@NotNull Template template, @NotNull PsiElement element) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/lang/javascript/template/postfix/JSForOfPostfixTemplate", "setVariables"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSForOfPostfixTemplate", "setVariables"));
        }
        MacroCallNode name = new MacroCallNode((Macro)new JSSuggestVariableNameMacro());
        template.addVariable("name", (Expression)name, (Expression)name, true);
    }
}

