/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSNoBalloonIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceVarPostfixTemplate
extends PostfixTemplateWithExpressionSelector {
    public JSIntroduceVarPostfixTemplate() {
        this("var", "var name = expr", JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset());
    }

    protected JSIntroduceVarPostfixTemplate(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/template/postfix/JSIntroduceVarPostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/lang/javascript/template/postfix/JSIntroduceVarPostfixTemplate", "<init>"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/lang/javascript/template/postfix/JSIntroduceVarPostfixTemplate", "<init>"));
        }
        super(name, example, selector);
    }

    protected void expandForChooseExpression(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/template/postfix/JSIntroduceVarPostfixTemplate", "expandForChooseExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/template/postfix/JSIntroduceVarPostfixTemplate", "expandForChooseExpression"));
        }
        JSIntroduceVariableHandler handler = this.getHandler();
        editor.getSelectionModel().setSelection(context.getTextRange().getStartOffset(), context.getTextRange().getEndOffset());
        handler.invoke(context.getProject(), editor, context.getContainingFile(), null);
    }

    private JSIntroduceVariableHandler getHandler() {
        return ApplicationManager.getApplication().isUnitTestMode() ? this.getMockHandlerForTestMode() : new JSNoBalloonIntroduceVariableHandler(){

            @Override
            protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope) {
                return JSIntroduceVarPostfixTemplate.this.getIntroduceVarType();
            }
        };
    }

    @NotNull
    protected Settings.IntroducedVarType getIntroduceVarType() {
        Settings.IntroducedVarType introducedVarType = Settings.IntroducedVarType.VAR;
        if (introducedVarType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/template/postfix/JSIntroduceVarPostfixTemplate", "getIntroduceVarType"));
        }
        return introducedVarType;
    }

    private JSIntroduceVariableHandler getMockHandlerForTestMode() {
        return new JSNoBalloonIntroduceVariableHandler(){

            @Override
            @Nullable
            protected Settings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
                return JSIntroduceVarPostfixTemplate.this.getMockSettings();
            }

            @Override
            protected InplaceSettings<Settings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, OccurrencesChooser.ReplaceChoice choice) {
                final InplaceSettings<Settings> settings = super.getInplaceSettings(expr, occurrences, scope, choice);
                return new InplaceSettings<Settings>(){

                    @Override
                    public String[] getSuggestedNames() {
                        return settings.getSuggestedNames();
                    }

                    @Override
                    public Settings getSettings() {
                        return JSIntroduceVarPostfixTemplate.this.getMockSettings();
                    }
                };
            }
        };
    }

    private Settings getMockSettings() {
        return new Settings(){

            @Override
            public Settings.IntroducedVarType getIntroducedVarType() {
                return JSIntroduceVarPostfixTemplate.this.getIntroduceVarType();
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return true;
            }

            @Override
            public String getVariableName() {
                return "foo";
            }

            @Override
            public String getVariableType() {
                return null;
            }
        };
    }
}

