/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSFileElementType
extends IStubFileElementType {
    private static final int BASE_VERSION = 239;
    private static final Map<Language, JSFileElementType> INSTANCES = new THashMap();

    protected JSFileElementType(Language language) {
        super(language);
    }

    public static JSFileElementType create(Language language) {
        JSFileElementType type = new JSFileElementType(language);
        INSTANCES.put(language, type);
        return type;
    }

    protected Language getLanguageForParser(PsiElement psi) {
        return JSLanguageUtil.getLanguageForParser(psi);
    }

    @NotNull
    public String getExternalId() {
        String string = this.getLanguage() + ":" + this.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSFileElementType", "getExternalId"));
        }
        return string;
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        return JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file);
    }

    public int getStubVersion() {
        return JSFileElementType.getVersion();
    }

    public static int getVersion() {
        return 239 + JavaScriptIndex.getVersionStatic();
    }

    public StubBuilder getBuilder() {
        return new JSFileStubBuilder();
    }

    public void serialize(@NotNull PsiFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/types/JSFileElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSFileElementType", "serialize"));
        }
        dataStream.writeName(stub.getType().getLanguage().getID());
        JSFileCachedData cachedData = ((JSFileStubImpl)stub).getCachedData();
        if (cachedData == null) {
            JSFile file = (JSFile)((JSFileStubImpl)stub).getPsi();
            if (file instanceof JSFileBaseImpl) {
                cachedData = ((JSFileBaseImpl)file).getCachedData();
            } else {
                cachedData = new JSFileCachedData();
                if (file != null) {
                    cachedData.applyModuleStatus(file.getModuleStatus());
                    cachedData.setTestFileType(file.getTestFileType());
                    if (file.hasES6Syntax()) {
                        cachedData.setHasES6Syntax();
                    }
                    cachedData.setReferencedPaths(file.getReferencedPaths());
                    cachedData.setExportsInnerAlias(file.getExportsInnerAlias());
                }
            }
        }
        cachedData.serialize(dataStream);
    }

    @NotNull
    public PsiFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSFileElementType", "deserialize"));
        }
        String languageId = dataStream.readName().getString();
        JSFileCachedData cachedData = JSFileCachedData.deserialize(dataStream);
        JSFileStubImpl jSFileStubImpl = new JSFileStubImpl(Language.findLanguageByID((String)languageId), cachedData);
        if (jSFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSFileElementType", "deserialize"));
        }
        return jSFileStubImpl;
    }

    public static JSFileElementType getByLanguage(Language language) {
        return INSTANCES.get(language);
    }

    public static Map<Language, JSFileElementType> getAll() {
        return INSTANCES;
    }
}

