/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringObjectImpl;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.impl.JSVarStatementImpl;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSVarStatementStubImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JSVarStatementElementType
extends JSStubElementType<JSVarStatementStub, JSVarStatement> {
    public JSVarStatementElementType() {
        this("VAR_STATEMENT");
    }

    public JSVarStatementElementType(String name) {
        super(name);
    }

    public boolean shouldCreateStub(ASTNode node) {
        return JSVarStatementElementType.shouldCreateStubForVarContainer(node);
    }

    public static boolean shouldCreateStubForVarContainer(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/types/JSVarStatementElementType", "shouldCreateStubForVarContainer"));
        }
        IElementType type = node.getElementType();
        if (type == JSStubElementTypes.DESTRUCTURING_OBJECT) {
            ASTNode[] properties;
            for (ASTNode property : properties = JSDestructuringObjectImpl.getProperties(node)) {
                ASTNode element = JSDestructuringPropertyBase.getDestructuringElement(property);
                if (element == null || !JSVarStatementElementType.shouldCreateStubForVarContainer(element)) continue;
                return true;
            }
        } else if (JSElementTypes.VAR_STATEMENTS.contains(type) || JSElementTypes.DESTRUCTURING_CONTAINERS.contains(type)) {
            ASTNode[] children;
            for (ASTNode child : children = node.getChildren(JSDestructuringVisitor.VAR_AND_CONTAINERS)) {
                if (!JSVarStatementElementType.shouldCreateStubForVarContainer(child)) continue;
                return true;
            }
        } else if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type) && type instanceof IStubElementType) {
            return ((IStubElementType)type).shouldCreateStub(node);
        }
        return false;
    }

    @NotNull
    public JSVarStatementStub createStub(@NotNull JSVarStatement psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSVarStatementElementType", "createStub"));
        }
        JSVarStatementStubImpl jSVarStatementStubImpl = new JSVarStatementStubImpl(psi, parentStub, (IStubElementType)this);
        if (jSVarStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSVarStatementElementType", "createStub"));
        }
        return jSVarStatementStubImpl;
    }

    public PsiElement construct(ASTNode node) {
        return new JSVarStatementImpl(node);
    }

    @NotNull
    public JSVarStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSVarStatementElementType", "deserialize"));
        }
        JSVarStatementStubImpl jSVarStatementStubImpl = new JSVarStatementStubImpl(dataStream, parentStub, (IStubElementType)this);
        if (jSVarStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSVarStatementElementType", "deserialize"));
        }
        return jSVarStatementStubImpl;
    }
}

