/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConstructorChecker {
    @NotNull
    protected final JSAnnotatorProblemReporter myProblemReporter;

    public JSConstructorChecker(@NotNull JSAnnotatorProblemReporter problemReporter) {
        if (problemReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemReporter", "com/intellij/lang/javascript/validation/JSConstructorChecker", "<init>"));
        }
        this.myProblemReporter = problemReporter;
    }

    public void checkConstructor(@NotNull JSFunction constructor, @NotNull JSClass jsClass) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/validation/JSConstructorChecker", "checkConstructor"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/JSConstructorChecker", "checkConstructor"));
        }
        if (this.isBaseConstructorCallValid(constructor, jsClass)) {
            this.checkInstanceMemberAccesses(constructor, jsClass);
        }
    }

    protected boolean isBaseConstructorCallValid(@NotNull JSFunction constructor, @NotNull JSClass jsClass) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/validation/JSConstructorChecker", "isBaseConstructorCallValid"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/JSConstructorChecker", "isBaseConstructorCallValid"));
        }
        if (jsClass.isInterface()) {
            return true;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)jsClass);
        boolean isECMA6ClassImplementation = dialect != null && (dialect.isECMA6 || dialect.isTypeScript);
        JSReferenceList referenceList = jsClass.getExtendsList();
        boolean isDerived = referenceList != null && !ArrayUtil.isEmpty((Object[])referenceList.getExpressions());
        JSFunction nontrivialSuperClassConstructor = JSConstructorChecker.getNontrivialSuperClassConstructor(jsClass);
        JSCallExpression baseConstructorCall = this.findAnyBaseConstructorCall(constructor);
        if (!isDerived && baseConstructorCall != null && isECMA6ClassImplementation) {
            String message = JSBundle.message((String)"javascript.validation.message.base.constructor.in.not.derived", (Object[])new Object[0]);
            this.myProblemReporter.registerGenericError((PsiElement)baseConstructorCall, message, new IntentionAction[0]);
        } else if (isDerived && (isECMA6ClassImplementation || nontrivialSuperClassConstructor != null) && baseConstructorCall == null) {
            String message;
            PsiElement place = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)constructor);
            Annotation annotation = this.myProblemReporter.registerGenericError(place, message = JSBundle.message((String)"javascript.validation.message.missed.super.constructor.call", (Object[])new Object[0]), new IntentionAction[0]);
            if (annotation == null) {
                return true;
            }
            annotation.registerFix(JSFixFactory.getInstance().addSuperInvocationFix(constructor, nontrivialSuperClassConstructor));
            return false;
        }
        return true;
    }

    protected void checkInstanceMemberAccesses(@NotNull JSFunction constructor, @NotNull JSClass clazz) {
        boolean isDerivedClass;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/validation/JSConstructorChecker", "checkInstanceMemberAccesses"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/validation/JSConstructorChecker", "checkInstanceMemberAccesses"));
        }
        boolean bl = isDerivedClass = !ArrayUtil.isEmpty((Object[])clazz.getSuperClasses());
        if (!isDerivedClass) {
            return;
        }
        InstanceAccessValidatingVisitor visitor = new InstanceAccessValidatingVisitor();
        constructor.acceptChildren((PsiElementVisitor)visitor);
        for (JSCallExpression constructorCall : visitor.baseConstructorCalls) {
            new InstanceAccessValidatingVisitor().visitElement((PsiElement)constructorCall.getArgumentList());
        }
    }

    @Contract(value="null -> null")
    protected JSCallExpression findAnyBaseConstructorCall(@Nullable JSFunction jsFunction) {
        if (jsFunction == null) {
            return null;
        }
        final Ref result = new Ref();
        JSSingleScopeVisitor visitor = new JSSingleScopeVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (result.get() != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitJSCallExpression(JSCallExpression node) {
                if (JSConstructorChecker.isBaseConstructorCall(node)) {
                    result.set((Object)node);
                    return;
                }
                super.visitJSCallExpression(node);
            }
        };
        jsFunction.acceptChildren((PsiElementVisitor)visitor);
        return (JSCallExpression)result.get();
    }

    @Nullable
    public static JSFunction getNontrivialSuperClassConstructor(@NotNull JSClass clazz) {
        JSFunction constructor;
        JSClass[] classes;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/validation/JSConstructorChecker", "getNontrivialSuperClassConstructor"));
        }
        if (clazz instanceof TypeScriptClass) {
            for (JSFunction function : ((TypeScriptClass)clazz).getIndirectSuperConstructors()) {
                if (!ValidateTypesUtil.hasRequiredParameters(function)) continue;
                return function;
            }
        }
        if ((classes = clazz.getSuperClasses()).length > 0 && (constructor = classes[0].getConstructor()) != null) {
            return ValidateTypesUtil.hasRequiredParameters(constructor) ? constructor : null;
        }
        return null;
    }

    public static boolean isBaseConstructorCall(JSCallExpression callExpression) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        return methodExpression != null && methodExpression instanceof JSSuperExpression;
    }

    private static class JSSingleScopeVisitor
    extends JSRecursiveElementVisitor {
        private JSSingleScopeVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (!JSUtils.isScopeOwner(element)) {
                super.visitElement(element);
            }
        }
    }

    private class InstanceAccessValidatingVisitor
    extends JSSingleScopeVisitor {
        boolean myBaseConstructorVisited;
        public final List<JSCallExpression> baseConstructorCalls = ContainerUtil.newArrayList();

        private InstanceAccessValidatingVisitor() {
        }

        public void visitJSCallExpression(JSCallExpression node) {
            if (JSConstructorChecker.isBaseConstructorCall(node)) {
                this.baseConstructorCalls.add(node);
                this.myBaseConstructorVisited = true;
            } else {
                super.visitJSCallExpression(node);
            }
        }

        public void visitJSThisExpression(JSThisExpression node) {
            if (!this.myBaseConstructorVisited) {
                this.registerReferenceError((PsiElement)node, JSBundle.message((String)"javascript.validation.message.this.before.super.call", (Object[])new Object[0]));
            }
        }

        public void visitJSSuperExpression(JSSuperExpression superExpression) {
            if (!this.myBaseConstructorVisited) {
                this.registerReferenceError((PsiElement)superExpression, JSBundle.message((String)"javascript.validation.message.baseMethod.before.super.call", (Object[])new Object[0]));
            }
        }

        private void registerReferenceError(@NotNull PsiElement target, @NotNull String message) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/validation/JSConstructorChecker$InstanceAccessValidatingVisitor", "registerReferenceError"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/validation/JSConstructorChecker$InstanceAccessValidatingVisitor", "registerReferenceError"));
            }
            PsiElement highlightTarget = PsiTreeUtil.getParentOfType((PsiElement)target, JSReferenceExpression.class);
            highlightTarget = highlightTarget == null ? target : highlightTarget;
            JSConstructorChecker.this.myProblemReporter.registerGenericError(highlightTarget, message, new IntentionAction[0]);
        }
    }
}

