/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.MarkerPsiElementPointer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateMethodsFix<T extends JSNamedElement> {
    private final Set<T> elementsToProcess;
    @NotNull
    protected final JSClass myJsClass;
    protected PsiElement anchor;

    public BaseCreateMethodsFix(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "<init>"));
        }
        this.elementsToProcess = new LinkedHashSet<T>();
        this.myJsClass = jsClass;
    }

    public void beforeInvoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "beforeInvoke"));
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        this.evalAnchor(editor, file);
        MultiMap types = MultiMap.createSet();
        Set<T> elementsToProcess = this.getElementsToProcess();
        for (JSNamedElement element : elementsToProcess) {
            this.fixName(element);
        }
        for (JSNamedElement e : elementsToProcess) {
            for (String type : this.getTypes(e)) {
                String resolved = JSImportHandlingUtil.resolveTypeName(type, (PsiElement)e);
                if (type.indexOf(46) == -1 && resolved.equals(type)) continue;
                types.putValue((Object)JSResolveUtil.getShortTypeName(type, false), (Object)resolved);
            }
        }
        this.processElements(project, (MultiMap<String, String>)types, elementsToProcess);
    }

    protected void processElements(Project project, MultiMap<String, String> types, Set<T> elementsToProcess) {
        ArrayList<MarkerPsiElementPointer> elementPointers = new ArrayList<MarkerPsiElementPointer>();
        for (JSNamedElement element : elementsToProcess) {
            elementPointers.add(new MarkerPsiElementPointer((PsiElement)element));
        }
        elementsToProcess.clear();
        for (MarkerPsiElementPointer e : elementPointers) {
            JSNamedElement element = (JSNamedElement)e.getElement();
            this.anchor = this.doAddOneMethod(project, this.buildFunctionText(element, types), this.anchor);
            elementsToProcess.add(element);
        }
    }

    protected void fixName(T t) {
    }

    protected void evalAnchor(@Nullable Editor editor, PsiFile file) {
        PsiElement parent;
        PsiElement at;
        this.anchor = null;
        if (editor == null) {
            return;
        }
        if (file instanceof XmlFile) {
            PsiElement element;
            file = ((XmlBackedJSClassImpl)this.myJsClass).createOrGetFirstScriptTag();
            editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file);
            PsiElement lastChild = file.getLastChild();
            PsiElement psiElement = element = lastChild == null ? null : lastChild.getPrevSibling();
            if (element != null) {
                this.anchor = element;
                return;
            }
        }
        if ((at = file.findElementAt(editor.getCaretModel().getOffset())) != null && ((parent = at.getParent()) == this.myJsClass || parent instanceof JSFile && this.myJsClass.getParent().getContainingFile() == parent.getContext().getContainingFile())) {
            ASTNode atNode = at.getNode();
            if (atNode.getElementType() == JSTokenTypes.RBRACE) {
                return;
            }
            for (ASTNode node = atNode; node != null; node = node.getTreeNext()) {
                if (node.getElementType() != JSTokenTypes.LBRACE) continue;
                return;
            }
            this.anchor = at;
        }
    }

    public PsiElement doAddOneMethod(Project project, String functionText, PsiElement anchor) throws IncorrectOperationException {
        return BaseCreateMethodsFix.addOneMethodToClass(this.myJsClass, project, functionText, anchor);
    }

    @Nullable
    public static PsiElement addOneMethodToClass(@NotNull JSClass clazz, Project project, @Nullable String functionText, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "addOneMethodToClass"));
        }
        if (functionText != null && functionText.length() > 0) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)clazz);
            PsiElement element = JSChangeUtil.createClassMemberFromText(project, functionText, dialect).getPsi();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            if (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (anchor != null && anchor.isValid() && (!(anchor instanceof PsiWhiteSpace) || !JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(dialect) || BaseCreateMethodsFix.isNotSurroundedCDATA(anchor))) {
                PsiElement newAnchor = anchor.getParent().addAfter(element, anchor);
                codeStyleManager.reformatNewlyAddedElement(newAnchor.getParent().getNode(), newAnchor.getNode());
                return newAnchor;
            }
            anchor = BaseCreateMethodsFix.addMethodToClassWithoutAnchor(clazz, dialect, element, codeStyleManager);
        }
        return anchor;
    }

    public static PsiElement addMethodToClassWithoutAnchor(@NotNull JSClass jsClass, @Nullable JSLanguageDialect dialect, @NotNull PsiElement element, @Nullable CodeStyleManager codeStyleManager) {
        PsiElement anchor;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "addMethodToClassWithoutAnchor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "addMethodToClassWithoutAnchor"));
        }
        if (!JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(dialect)) {
            ASTNode possibleAnchor = jsClass.getNode().findChildByType(JSTokenTypes.LBRACE);
            assert (possibleAnchor != null);
            anchor = jsClass.addAfter(element, possibleAnchor.getPsi());
            if (codeStyleManager != null) {
                PsiElement parent = anchor.getParent();
                codeStyleManager.reformatNewlyAddedElement(parent.getNode(), anchor.getNode());
            }
        } else {
            anchor = jsClass.add(element);
        }
        return anchor;
    }

    private static boolean isNotSurroundedCDATA(PsiElement anchor) {
        String anchorText = anchor.getText();
        return !anchorText.contains("<![CDATA[") && !anchorText.contains("]]>");
    }

    private Collection<String> getTypes(T fun) {
        if (fun instanceof JSFunction) {
            return BaseCreateMethodsFix.getFunctionTypes((JSFunction)fun);
        }
        if (fun instanceof JSVariable) {
            ArrayList<String> result = new ArrayList<String>();
            JSType type = ((JSVariable)fun).getType();
            if (type != null) {
                result.add(type.getTypeText(JSType.TypeTextFormat.CODE));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Collection<String> getFunctionTypes(JSFunction function) {
        ArrayList<String> result = new ArrayList<String>();
        if (function.getReturnType() != null) {
            result.add(function.getReturnType().getTypeText(JSType.TypeTextFormat.CODE));
        }
        for (JSParameterListElement param : function.getParameterList().getParameters()) {
            JSType type = param.getType();
            if (type == null) continue;
            result.add(type.getTypeText(JSType.TypeTextFormat.CODE));
        }
        return result;
    }

    public String buildFunctionText(T fun, @Nullable MultiMap<String, String> types) {
        String attrText = "";
        if (fun instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)fun).getAttributeList();
            JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(attributeList);
            String namespace = attributeListWrapper.getNamespaceValue();
            if (namespace != null && attributeList != null) {
                String namespaceId = BaseCreateMethodsFix.calcNamespaceId(attributeList, namespace, (PsiElement)(this.anchor != null ? this.anchor : this.myJsClass));
                namespaceId = this.importType(namespaceId, fun, types);
                attributeListWrapper.overrideNamespace(namespaceId);
            }
            this.adjustAttributeList(attributeListWrapper, fun);
            attrText = attributeListWrapper.computeText(DialectDetector.dialectOfElement((PsiElement)this.myJsClass));
        }
        String typeString = null;
        JSParameterList parameterList = null;
        JSType type = null;
        if (fun instanceof JSVariable || fun instanceof JSFunction) {
            JSFunction function = fun instanceof JSFunction ? (JSFunction)fun : null;
            JSVariable var = fun instanceof JSVariable ? (JSVariable)fun : null;
            parameterList = function != null ? function.getParameterList() : null;
            JSType jSType = type = function != null ? function.getReturnType() : var.getType();
        }
        if (type != null) {
            typeString = this.getTypeString(type, fun, types);
        } else if (this.shouldHandleNoTypeAsAnyType()) {
            typeString = JSClassUtils.getAnyTypeString((PsiElement)this.myJsClass, false);
        }
        String functionText = attrText;
        if (functionText.length() > 0) {
            functionText = functionText + " ";
        }
        functionText = functionText + JSClassUtils.createClassFunctionName(this.buildFunctionKind(fun) + this.buildName(fun), (PsiElement)this.myJsClass);
        functionText = functionText + this.buildParameterList(parameterList, fun, types);
        String string = typeString = typeString != null ? this.buildReturnType(typeString) : null;
        if (typeString != null) {
            functionText = functionText + ":" + typeString;
        }
        functionText = functionText + this.buildFunctionBodyText(typeString, parameterList, fun);
        return functionText;
    }

    @Nullable
    protected static String calcNamespaceId(@NotNull JSAttributeList attributeList, final String namespace, @NotNull PsiElement anchor) {
        if (attributeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeList", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "calcNamespaceId"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/validation/fixes/BaseCreateMethodsFix", "calcNamespaceId"));
        }
        if (namespace == null) {
            return null;
        }
        Map<String, String> ns2Id = JSResolveUtil.calculateOpenNses(anchor);
        String namespaceId = ns2Id.get(namespace);
        if (namespaceId != null) {
            return namespaceId;
        }
        final GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)attributeList.getProject());
        final Ref namespaceVar = new Ref();
        JSPackageIndex.processElementsInScopeRecursive("", new JSPackageIndex.PackageQualifiedElementsProcessor(){

            @Override
            public boolean process(String qualifiedName, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                String initializerText;
                if (kind != JSPackageIndexInfo.Kind.VARIABLE) {
                    return true;
                }
                PsiElement classByQName = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(qualifiedName, searchScope);
                if (classByQName instanceof JSVariable && (initializerText = ((JSVariable)classByQName).getLiteralOrReferenceInitializerText()) != null && namespace.equals(StringUtil.stripQuotesAroundValue((String)initializerText))) {
                    namespaceVar.set((Object)((JSVariable)classByQName).getName());
                    return false;
                }
                return true;
            }
        }, searchScope, attributeList.getProject());
        namespaceId = (String)namespaceVar.get();
        if (namespaceId == null) {
            namespaceId = attributeList.getNamespace();
        }
        return namespaceId;
    }

    protected boolean shouldHandleNoTypeAsAnyType() {
        return false;
    }

    @NonNls
    protected String buildReturnType(String typeString) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myJsClass);
        if (holder != null && !holder.hasFeature(JSLanguageFeature.TYPES)) {
            return null;
        }
        return typeString;
    }

    @Nullable
    protected String getTypeString(JSType type, T fun, @Nullable MultiMap<String, String> types) {
        if (type == null) {
            return null;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myJsClass);
        if (holder == null) {
            return null;
        }
        if (!holder.hasFeature(JSLanguageFeature.TYPES)) {
            return null;
        }
        String typeString = null;
        if (holder.isECMA4) {
            String resolvedTypeText = this.importType(type.getTypeText(JSType.TypeTextFormat.CODE), fun, types);
            if (!StringUtil.isEmpty((String)resolvedTypeText)) {
                typeString = resolvedTypeText;
            }
        } else {
            typeString = BaseCreateMethodsFix.getProcessedType(type, this.myJsClass, fun);
        }
        return typeString;
    }

    @Nullable
    public static String getProcessedType(@Nullable JSType type, JSClass surroundClass, PsiElement context) {
        String stringType;
        if (type == null) {
            return null;
        }
        if (JSTypeUtils.hasGenericParameter(type = JSTypeUtils.getValuableType(type))) {
            type = TypeScriptUtil.applyGenericsToType(type, surroundClass, context instanceof JSClass ? (JSClass)context : JSResolveUtil.getClassOfContext(context));
        }
        if (TypeScriptUtil.hasAmbientExternalModuleInQName(stringType = type.getTypeText(JSType.TypeTextFormat.CODE)) && TypeScriptUtil.hasAmbientExternalModuleInQName(stringType = type.getTypeText())) {
            return null;
        }
        return stringType;
    }

    protected String importType(String s, T fun, @Nullable MultiMap<String, String> types) {
        if (s == null) {
            return null;
        }
        if (fun instanceof JSFunction || fun instanceof JSVariable) {
            Collection fullNames;
            String resolvedTypeName = JSImportHandlingUtil.resolveTypeName(s, fun);
            if (StringUtil.isEmpty((String)resolvedTypeName)) {
                return s;
            }
            boolean allowShorten = types == null ? true : (fullNames = types.get((Object)JSResolveUtil.getShortTypeName(s, false))).isEmpty() || fullNames.size() == 1 && ((String)fullNames.iterator().next()).equals(resolvedTypeName);
            Pair<String, PsiElement> importResult = ImportUtils.importAndShortenReference(resolvedTypeName, (PsiElement)(this.anchor != null ? this.anchor : this.myJsClass), true, allowShorten);
            String result = (String)importResult.first;
            if (this.anchor != null) {
                this.anchor = (PsiElement)importResult.second;
            }
            return JSResolveUtil.getQualifiedTypeName(result);
        }
        return s;
    }

    protected String buildParameterList(JSParameterList parameterList, T fun, MultiMap<String, String> types) {
        if (parameterList != null) {
            boolean isTypeScriptFunction;
            StringBuilder signature = new StringBuilder();
            boolean isExpectedCodeTypeScript = DialectDetector.isTypeScript((PsiElement)this.myJsClass);
            boolean bl = isTypeScriptFunction = fun instanceof TypeScriptFunction && isExpectedCodeTypeScript;
            if (isTypeScriptFunction) {
                signature.append(TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics((TypeScriptFunction)fun, this.myJsClass));
            }
            signature.append('(');
            boolean firstParameter = true;
            for (JSParameterListElement param : parameterList.getParameters()) {
                JSExpression initializer;
                if (!firstParameter) {
                    signature.append(", ");
                }
                firstParameter = false;
                if (param.isRest()) {
                    signature.append("... ").append(param.getName());
                    continue;
                }
                JSType type = param.getType();
                String s = this.getTypeString(type, fun, types);
                signature.append(param.getName());
                if (isTypeScriptFunction && param.isOptional()) {
                    signature.append("?");
                }
                if (!StringUtil.isEmpty((String)s)) {
                    signature.append(":").append(s);
                }
                if ((initializer = param.getInitializer()) == null) continue;
                signature.append(" = ").append(initializer.getText());
            }
            signature.append(")");
            return signature.toString();
        }
        return "()";
    }

    protected String buildName(T fun) {
        return JSPsiImplUtils.getNameOrComputedPropertyName(fun);
    }

    @NonNls
    protected String buildFunctionKind(T fun) {
        if (fun instanceof JSFunction) {
            JSFunction function = (JSFunction)fun;
            if (function.isGetProperty()) {
                return "get ";
            }
            if (function.isSetProperty()) {
                return "set ";
            }
        }
        return "";
    }

    @NonNls
    protected String buildFunctionBodyText(@NonNls String retType, JSParameterList parameterList, T func) {
        return " {}";
    }

    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, T function) {
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.NATIVE, false);
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, false);
    }

    public void addElementToProcess(T function) {
        this.elementsToProcess.add(function);
    }

    public Set<T> getElementsToProcess() {
        JSNamedElement[] objects = this.elementsToProcess.toArray(new JSNamedElement[this.elementsToProcess.size()]);
        Comparator tComparator = (o1, o2) -> o1.getTextOffset() - o2.getTextOffset();
        int size = this.elementsToProcess.size();
        LinkedHashSet result = new LinkedHashSet(size);
        ArrayList<JSNamedElement> objectsFromSameFile = new ArrayList<JSNamedElement>();
        PsiFile containingFile = null;
        for (int i = 0; i < size; ++i) {
            JSNamedElement object = objects[i];
            PsiFile currentContainingFile = object.getContainingFile();
            if (currentContainingFile != containingFile) {
                if (containingFile != null) {
                    Collections.sort(objectsFromSameFile, tComparator);
                    result.addAll(objectsFromSameFile);
                    objectsFromSameFile.clear();
                }
                containingFile = currentContainingFile;
            }
            objectsFromSameFile.add(object);
        }
        Collections.sort(objectsFromSameFile, tComparator);
        result.addAll(objectsFromSameFile);
        this.elementsToProcess.clear();
        this.elementsToProcess.addAll(result);
        return this.elementsToProcess;
    }
}

