/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CreateJSParameterIntentionAction
extends BaseCreateJSVariableIntentionAction {
    public CreateJSParameterIntentionAction(String referencedName) {
        super(referencedName);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"javascript.fix.create.parameter", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction", "getName"));
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        final JSReferenceExpression node = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSReferenceExpression.class);
        if (node == null) {
            return;
        }
        JSParameterInserter parameterInserter = JSParameterInserter.build((PsiElement)node);
        if (parameterInserter == null) {
            return;
        }
        boolean b = ReferencesSearch.search((PsiElement)parameterInserter.getFunction()).forEach(psiReference -> JSResolveUtil.isSelfReference(psiReference.getElement()));
        JSLanguageDialect languageDialect = JSUtils.getDialect(file);
        String type = null;
        if (languageDialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            type = BaseCreateFix.guessTypeForExpression((JSExpression)node, file, false);
        }
        if (!b) {
            TextRange textRange = node.getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            final String finalType = type;
            new JSIntroduceParameterHandler(){

                @Override
                protected JSIntroduceParameterSettings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        return new JSIntroduceParameterSettings.Base(expressionDescriptor){

                            @Override
                            public boolean addOptionalParameter() {
                                return parameterInserter.mustBeOptional();
                            }

                            @Override
                            public String getInitialValue() {
                                return JSTypeUtils.defaultValueOfType(finalType);
                            }

                            @Override
                            public boolean isReplaceAllOccurrences() {
                                return true;
                            }

                            @Override
                            public String getVariableName() {
                                return node.getReferencedName();
                            }

                            @Override
                            public String getVariableType() {
                                return finalType;
                            }
                        };
                    }
                    return (JSIntroduceParameterSettings)super.getSettings(project, editor, expressionDescriptor, occurrences, scope);
                }
            }.invoke(project, editor, file, DataManager.getInstance().getDataContext());
            return;
        }
        String typeDecoration = "";
        if (languageDialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4 && type != null) {
            typeDecoration = typeDecoration + ":" + type;
        }
        boolean mustBeOptional = parameterInserter.mustBeOptional();
        String introduced = node.getReferencedName() + typeDecoration;
        if (mustBeOptional) {
            introduced = introduced + "=" + JSTypeUtils.defaultValueOfType(type);
        }
        String finalIntroduced = introduced;
        WriteAction.run(() -> {
            JSParameter parameter = parameterInserter.doInsert(finalIntroduced, mustBeOptional, "");
            CodeStyleManager.getInstance((Project)project).reformat(parameter.getParent());
        });
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
    }
}

