/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import icons.JavaScriptLanguageIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptLanguageServiceToolWindowManager
extends JSLanguageServiceToolWindowManager {
    private final Project myProject;
    private final TypeScriptCompilerSettings mySettings;
    private volatile ToggleAction showErrors;

    TypeScriptLanguageServiceToolWindowManager(Project project, TypeScriptCompileCurrentAction typeScriptCompileCurrentAction, AnAction restartCompilerAction, TypeScriptCompilerSettings settings) {
        super(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, typeScriptCompileCurrentAction, new TypeScriptCompileAllAction(), restartCompilerAction);
        this.myProject = project;
        this.mySettings = settings;
    }

    @Override
    @NotNull
    protected ConsoleViewImpl createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){

            public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$1", "print"));
                }
                if (contentType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$1", "print"));
                }
                if (!TypeScriptLanguageServiceToolWindowManager.this.myProject.isOpen() || TypeScriptLanguageServiceToolWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
                    super.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
                } else if (contentType == ConsoleViewContentType.NORMAL_OUTPUT && JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                    if (s.length() > 1000) {
                        s = s.substring(0, 1000) + "............(truncated)\n";
                    }
                    super.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
        };
        if (consoleViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager", "createConsole"));
        }
        return consoleViewImpl;
    }

    @Override
    protected AnAction[] getErrorPanelRightActions(boolean all) {
        if (all) {
            return super.getErrorPanelRightActions(true);
        }
        String showErrorsText = JSBundle.message((String)"javascript.language.service.default.project.errors", (Object[])new Object[0]);
        this.showErrors = new ToggleAction(showErrorsText, showErrorsText, AllIcons.General.ProjectTab){

            public boolean isSelected(AnActionEvent e) {
                return TypeScriptLanguageServiceToolWindowManager.this.mySettings.isShowAllProjectErrors();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                TypeScriptLanguageServiceToolWindowManager.this.mySettings.setShowAllProjectErrors(state);
                DaemonCodeAnalyzer.getInstance((Project)TypeScriptLanguageServiceToolWindowManager.this.myProject).restart();
                NewErrorTreeViewPanel panel = TypeScriptLanguageServiceToolWindowManager.this.getCurrentErrorTreeViewPanel();
                if (panel != null) {
                    TypeScriptLanguageServiceToolWindowManager.this.updateCurrentErrorsEmptyText(panel);
                }
            }
        };
        return new AnAction[]{this.showErrors};
    }

    @Override
    @NotNull
    protected String getProjectErrorsTitle() {
        if ("Compile errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager", "getProjectErrorsTitle"));
        }
        return "Compile errors";
    }

    @Override
    public void setName(@Nullable String newName) {
        super.setName(newName);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
    }

    @Override
    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager", "updateCurrentErrorsEmptyText"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        StatusText text = panel.getEmptyText();
        if (!this.mySettings.isUseService() && !this.mySettings.isTrackFileSystemChanges()) {
            text.clear();
            text.setText(JSBundle.message((String)"javascript.language.service.tracking.disabled", (Object[])new Object[0]));
            return;
        }
        if (this.myServiceConsoles.isEmpty()) {
            text.clear();
            text.setText(JSBundle.message((String)"javascript.language.service.tracking.is.not.started", (Object[])new Object[0]));
            return;
        }
        if (!this.mySettings.isShowAllProjectErrors()) {
            text.clear();
            text.setText("No errors in the current file. ");
            text.appendText("Show project errors", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    TypeScriptLanguageServiceToolWindowManager.this.showErrors.setSelected(null, true);
                }
            });
            return;
        }
        super.updateCurrentErrorsEmptyText(panel);
    }

    @Override
    public boolean needActivateProgressPanel() {
        return true;
    }
}

