/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;

public class TypeScriptLanguageServiceAnnotationResult
extends JSLanguageServiceAnnotationResult {
    public static final int CANNOT_FIND_NAME_CODE = 2304;

    public TypeScriptLanguageServiceAnnotationResult(String errorText, String fileAbsolutePath, String category, int line, int column, int lineEnd, int columnEnd) {
        super(errorText, fileAbsolutePath, category, line, column, lineEnd, columnEnd);
    }

    @Override
    public int getErrorCode() {
        String prefix = "TS";
        if (this.myErrorText != null && this.myErrorText.startsWith(prefix)) {
            int endCode = this.myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = this.myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.valueOf(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public ProblemHighlightType getHighlightType() {
        int code = this.getErrorCode();
        if (code != -1 && this.getErrorText() != null && 2304 == code) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return null;
    }
}

