/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceStandardOutputProtocol
extends JSLanguageServiceNodeStdProtocolBase {
    private static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    private final AtomicInteger mySeq;

    public TypeScriptServiceStandardOutputProtocol(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "<init>"));
        }
        if (readyConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readyConsumer", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "<init>"));
        }
        super(project, readyConsumer);
        this.mySeq = new AtomicInteger();
        this.mySettings = settings;
    }

    @Override
    public Integer sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "sendCommand"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "sendCommand"));
        }
        int value = this.mySeq.getAndIncrement();
        if (resultConsumer != null) {
            this.myCallbacks.put(value, resultConsumer);
        }
        TypeScriptLanguageServiceRequest toSend = new TypeScriptLanguageServiceRequest(command, data, this.mySessionId, value);
        String jsonData = JSLanguageServiceQueue.GSON.toJson((Object)toSend);
        String request = jsonData + "\n";
        if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
            String toPrint = request;
            if (request.length() > 1000) {
                toPrint = request.substring(0, 200) + "\n ................................(truncated)";
            }
            JSLanguageServiceQueue.LOGGER.trace("Request: " + toPrint);
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Request command: " + command.getCommand());
        }
        this.write(request);
        return value;
    }

    @Override
    public TypeScriptServiceInitialStateObject createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        this.fillState(state);
        return state;
    }

    protected void fillState(TypeScriptServiceInitialStateObject state) {
        state.pluginName = "typescript";
        state.serverFolderPath = this.getServicePath();
        state.sessionId = String.valueOf(this.mySessionId);
        this.setManualOptions(state);
    }

    protected void setManualOptions(@NotNull TypeScriptServiceInitialStateObject state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "setManualOptions"));
        }
        boolean bl = state.hasManualParams = !this.mySettings.isUseConfigForCompiler() && this.mySettings.isCompilerEnabled();
        if (!state.hasManualParams) {
            return;
        }
        String params = this.mySettings.getTypeScriptCompilerParams();
        Object[] parsedParams = params == null ? ArrayUtil.EMPTY_STRING_ARRAY : ParametersList.parse((String)params);
        ArrayList paramList = ContainerUtil.newArrayList((Object[])parsedParams);
        String outFile = null;
        boolean hasMainFile = this.hasMainFile();
        if (this.hasOutputDirectory()) {
            state.projectPath = this.getProjectPathString();
            Pair<String, String> pair = null;
            try {
                pair = this.getOutInformation(hasMainFile);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (pair != null) {
                outFile = (String)pair.first;
                String outDir = (String)pair.second;
                if (!StringUtil.isEmpty((String)outDir)) {
                    if (outFile == null && !outDir.contains("$")) {
                        paramList.add("--outDir");
                        paramList.add(FileUtilRt.toSystemDependentName((String)outDir));
                    } else {
                        state.outPath = (String)pair.second;
                    }
                }
            }
        }
        boolean existsCommandLineOutParam = this.checkExistsCommandLineOut((String[])parsedParams);
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            paramList.add("--outFile");
            paramList.add(FileUtilRt.toSystemDependentName(outFile));
        }
        if (this.mySettings.isGenerateSourceMap()) {
            paramList.add("--sourceMap");
        }
        if (!paramList.isEmpty()) {
            state.commandLineArguments = ArrayUtil.toStringArray((Collection)paramList);
        }
        if (hasMainFile) {
            state.mainFilePath = this.mySettings.getMainFilePath();
        }
    }

    @NotNull
    protected String expandOutputDirectoryMacro() throws Macro.ExecutionCancelledException {
        String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)this.mySettings.getOutDirectory());
        DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
        for (Macro macro : PROJECT_LEVEL_MACRO) {
            String macroName = "$" + macro.getName() + "$";
            if (!outWithExpandedProjectMacro.contains(macroName)) continue;
            String expand = macro.expand(context);
            if (expand == null) {
                expand = "";
            }
            outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
        }
        String string = outWithExpandedProjectMacro;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "expandOutputDirectoryMacro"));
        }
        return string;
    }

    @Override
    protected String getNodeInterpreter() {
        return TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject);
    }

    @Override
    protected void addNodeProcessAdditionalArguments(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "addNodeProcessAdditionalArguments"));
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            commandLine.withEnvironment("TSS_LOG", JSLanguageServiceQueue.LOGGER.isTraceEnabled() ? "-level verbose" : "");
        }
        String nodeArgsRaw = null;
        try {
            nodeArgsRaw = Registry.stringValue((String)"typescript.service.node.arguments");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtil.isEmptyOrSpaces((String)nodeArgsRaw)) {
            String[] arguments = nodeArgsRaw.split("\n");
            commandLine.addParameters(arguments);
        }
    }

    protected String getServicePath() {
        VirtualFile libDirectory;
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        if (settings.getVersionType() == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED_OR_DETECTED && (libDirectory = TypeScriptLanguageServiceUtil.findTypeScriptLibDirectory(this.myProject)) != null) {
            return TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(libDirectory.getCanonicalPath()) + '/';
        }
        return TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(settings.getTypeScriptServiceDirectoryOrDefault()) + '/';
    }

    protected boolean hasMainFile() {
        return this.mySettings.isUseMainFile() && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    protected boolean hasOutputDirectory() {
        return this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)this.mySettings.getOutDirectory());
    }

    @NotNull
    protected Pair<String, String> getOutInformation(boolean hasMainFile) throws Macro.ExecutionCancelledException {
        int indexOfSeparator;
        int indexOfDot;
        String outFile = null;
        String outWithExpandedProjectMacro = this.expandOutputDirectoryMacro();
        if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
            if (indexOfSeparator >= 0) {
                outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
            } else {
                outFile = outWithExpandedProjectMacro;
                outWithExpandedProjectMacro = null;
            }
        }
        if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
            String path = FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro);
            Pair pair = Pair.create(outFile, (Object)path);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "getOutInformation"));
            }
            return pair;
        }
        Pair pair = Pair.create(outFile, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "getOutInformation"));
        }
        return pair;
    }

    @NotNull
    protected String getProjectPathString() {
        String path = this.myProject.getBasePath();
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "getProjectPathString"));
        }
        return string;
    }

    protected boolean checkExistsCommandLineOut(String[] parse) {
        for (String s : parse) {
            if (!"-out".equals(s)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }
}

