/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptLanguageServiceDialog;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServicePanel
extends JPanel {
    private final JButton myEditButton;
    private final TypeScriptCompilerSettings mySettings;
    private final List<TypeScriptServerServiceSettings> myAdditionalSettings;
    private JBCheckBox myUseService;
    private boolean myUseCompletion;
    private boolean myUseAnnotation;
    private Map<TypeScriptServerServiceSettings, Boolean> myAdditionalSettingsValues = ContainerUtil.newLinkedHashMap();

    public TypeScriptLanguageServicePanel(final @Nullable Project project, TypeScriptCompilerSettings settings, List<TypeScriptServerServiceSettings> additionalSettings) {
        super(new FlowLayout(0));
        this.mySettings = settings;
        this.myAdditionalSettings = additionalSettings;
        this.myUseService = new JBCheckBox(JSBundle.message((String)"typescript.use.service.configurable.options.enable", (Object[])new Object[0]));
        this.add((Component)this.myUseService, "Center");
        this.myEditButton = new JButton("Configure...");
        this.myUseService.addChangeListener(el -> this.myEditButton.setEnabled(this.myUseService.isSelected()));
        this.add((Component)this.myEditButton, "East");
        this.myEditButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeScriptLanguageServiceDialog dialog = new TypeScriptLanguageServiceDialog(project, TypeScriptLanguageServicePanel.this, TypeScriptLanguageServicePanel.this.myAdditionalSettings);
                if (dialog.showAndGet()) {
                    TypeScriptLanguageServicePanel.this.myUseCompletion = dialog.isUseCodeCompletion();
                    TypeScriptLanguageServicePanel.this.myUseAnnotation = dialog.isUseAnnotation();
                    TypeScriptLanguageServicePanel.this.myAdditionalSettingsValues = dialog.getAdditionalSettingsValues();
                }
            }
        });
    }

    public boolean isUseServiceAnnotation() {
        return this.myUseAnnotation;
    }

    public boolean isUseServiceCompletion() {
        return this.myUseCompletion;
    }

    public Map<TypeScriptServerServiceSettings, Boolean> getAdditionalSettingsValues() {
        return this.myAdditionalSettingsValues;
    }

    public void setDefaultValues() {
        this.myUseService.setSelected(this.mySettings.isUseService());
        this.myUseAnnotation = this.mySettings.isUseServiceAnnotation();
        this.myUseCompletion = this.mySettings.isUseServiceCompletion();
        this.myEditButton.setEnabled(this.myUseService.isSelected());
        this.myAdditionalSettingsValues.clear();
        for (TypeScriptServerServiceSettings setting : this.myAdditionalSettings) {
            this.myAdditionalSettingsValues.put(setting, setting.isUseService());
        }
    }

    public boolean isModified() {
        boolean value;
        boolean bl = value = this.mySettings.isUseService() != this.myUseService.isSelected() || this.mySettings.isUseServiceCompletion() != this.myUseCompletion || this.mySettings.isUseServiceAnnotation() != this.myUseAnnotation;
        if (value) {
            return true;
        }
        for (TypeScriptServerServiceSettings setting : this.myAdditionalSettings) {
            if (Boolean.TRUE.equals(this.myAdditionalSettingsValues.get(setting)) == setting.isUseService()) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        this.mySettings.setUseService(this.myUseService.isSelected());
        this.mySettings.setUseServiceCompletion(this.myUseCompletion);
        this.mySettings.setUseServiceAnnotation(this.myUseAnnotation);
        this.myEditButton.setEnabled(this.myUseService.isSelected());
        for (TypeScriptServerServiceSettings setting : this.myAdditionalSettings) {
            setting.setUseService(Boolean.TRUE.equals(this.myAdditionalSettingsValues.get(setting)));
        }
    }
}

