/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompletionUtil {
    public static void addAllVariants(@NotNull JSReferenceExpression expression, @NotNull PsiFile containingFile, @NotNull Iterable sinkResults, final @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (completionResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        assert (expression.getQualifier() == null);
        final THashSet addedElements = new THashSet();
        for (Object object : sinkResults) {
            PsiElement sinkResult;
            if (object instanceof LookupElement) {
                sinkResult = ((LookupElement)object).getPsiElement();
            } else {
                if (!(object instanceof PsiElement)) continue;
                sinkResult = (PsiElement)object;
            }
            if (sinkResult instanceof ES6ImportExportSpecifier) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((ES6ImportExportSpecifier)sinkResult).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) continue;
                    addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)element));
                }
                continue;
            }
            if (sinkResult == null) continue;
            addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)sinkResult));
        }
        final Project project = containingFile.getProject();
        final JSInsertHandler<LookupElement> handler = TypeScriptCompletionUtil.createImportInsertHandler();
        final TypeScriptAutoImportUtil.JSReferencePlaceInfo info = new TypeScriptAutoImportUtil.JSReferencePlaceInfo((PsiElement)expression);
        final MultiMap symbolsToImport = MultiMap.createSet();
        JSReferenceCompletionContributor.processAllIndexedSymbols(new JSCompletionProcessor(){

            @Override
            public boolean acceptsFile(PsiFile file) {
                return file instanceof JSFile && DialectDetector.isTypeScript((PsiElement)file);
            }

            @Override
            public void doAdd(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil$1", "doAdd"));
                }
                if (!addedElements.contains((Object)element) && TypeScriptAutoImportUtil.isAvailableForImport((JSElement)element, info, project)) {
                    String name = element.getName();
                    if (name == null) {
                        return;
                    }
                    Collection classes = symbolsToImport.get((Object)name);
                    if (classes.contains(element.getClass())) {
                        return;
                    }
                    Class<?> elementClass = element.getClass();
                    symbolsToImport.putValue((Object)name, elementClass);
                    LookupElement item = TypeScriptCompletionUtil.createLookupElement(project, name, (PsiElement)element, (InsertHandler<LookupElement>)handler);
                    completionResultSet.addElement(item);
                }
            }
        }, project, TypeScriptAutoImportUtil.createSymbolToImportSearchScope((PsiElement)containingFile, project));
    }

    private static LookupElement createLookupElement(@NotNull Project project, @NotNull String name, @NotNull PsiElement element, @NotNull InsertHandler<LookupElement> handler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        return JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler(handler).withIcon(JSLookupUtilImpl.getIcon(element, false)), JSLookupPriority.NO_RELEVANT_NO_SMARTNESS_PRIORITY);
    }

    @NotNull
    public static JSInsertHandler<LookupElement> createImportInsertHandler() {
        JSInsertHandler<LookupElement> jSInsertHandler = new JSInsertHandler<LookupElement>(){

            @Override
            public void handleInsert(InsertionContext context, LookupElement item) {
                super.handleInsert(context, item);
                if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport()) {
                    return;
                }
                PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
                if (originalElement != null) {
                    String name = item.getLookupString();
                    PsiElement psiElement = item.getPsiElement();
                    if (psiElement instanceof JSQualifiedNamedElement) {
                        JSQualifiedNamedElement element = (JSQualifiedNamedElement)psiElement;
                        TypeScriptAutoImportUtil.addImportStatement(element.getName(), element, originalElement);
                    } else {
                        new TypeScriptAddImportStatementFix.ImportAction(context.getEditor(), originalElement, name).execute();
                    }
                }
            }
        };
        if (jSInsertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createImportInsertHandler"));
        }
        return jSInsertHandler;
    }
}

