/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
implements ImportOptimizer {
    public final boolean supports(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)file;
        return this.checkDialect(DialectDetector.dialectOfFile((PsiFile)jsFile));
    }

    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        if (!file.isValid() || DumbService.getInstance((Project)file.getProject()).isDumb()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        PsiElement[] declarations = JSResolveUtil.getStubbedChildren((PsiElement)file, TypeScriptAutoImportUtil.ES6_IMPORT_DECLARATION);
        if (declarations.length == 0) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        for (PsiElement declaration : declarations) {
            if (!(declaration instanceof ES6ImportDeclaration)) continue;
            infos.add(ES6UnusedImportsHelper.getInfo((ES6ImportDeclaration)declaration));
        }
        List<String> importTexts = this.buildNewImportsText(file, infos);
        Project project = file.getProject();
        Runnable runnable = () -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return;
            }
            HashMap prevDeclarations = ContainerUtil.newHashMap();
            for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
                ES6ImportDeclaration declaration = info.getDeclaration();
                prevDeclarations.put(declaration, Pair.create(ES6ImportOptimizer.getPrevComments(declaration), (Object)ES6ImportOptimizer.getLineComment(declaration)));
            }
            if (!importTexts.isEmpty()) {
                String text = StringUtil.join((Collection)importTexts, (String)"\n");
                PsiFile newFile = JSChangeUtil.createJSFileFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)file));
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)newFile);
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                assert (item != null);
                ES6ImportDeclaration declaration = item.getDeclaration();
                List<PsiElement> comments = ES6ImportOptimizer.getPrevComments(declaration);
                ES6ImportDeclaration anchor = declaration;
                if (comments.size() > 0) {
                    anchor = comments.get(0);
                }
                PsiElement siblingBeforeAnchor = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class});
                PsiElement parent = anchor.getParent();
                PsiElement element = SharedImplUtil.addRange((PsiElement)parent, (PsiElement)newFile.getFirstChild(), (PsiElement)newFile.getLastChild(), (ASTNode)anchor.getNode(), (Boolean)Boolean.TRUE);
                if (element instanceof PsiComment && !(siblingBeforeAnchor instanceof PsiComment)) {
                    JSChangeUtil.addWs(parent.getNode(), element.getNode(), "\n");
                }
            }
            for (int i = 0; i < infos.size(); ++i) {
                ES6UnusedImportsHelper.UnusedInfo info;
                info = (ES6UnusedImportsHelper.UnusedInfo)infos.get(i);
                boolean isFirst = i == 0;
                ES6ImportDeclaration declaration = info.getDeclaration();
                Pair pair = (Pair)prevDeclarations.get(declaration);
                List prevComments = (List)pair.first;
                PsiElement sameLineEndComment = (PsiElement)pair.second;
                boolean hasComments = prevComments.size() > 0;
                ES6ImportDeclaration beforeElement = hasComments ? (PsiElement)prevComments.get(0) : declaration;
                PsiElement afterElement = sameLineEndComment != null ? sameLineEndComment : declaration;
                ES6ImportOptimizer.deleteSiblingWhitespaceBetweenImports((PsiElement)beforeElement, afterElement, !isFirst, true);
                if (hasComments || sameLineEndComment != null) {
                    declaration.getParent().deleteChildRange((PsiElement)beforeElement, afterElement);
                    continue;
                }
                declaration.delete();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
        }
        return runnable;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSApplicationSettings.getInstance().isMergeImports();
        ArrayList importsResult = ContainerUtil.newArrayList();
        HashSet visitedImports = ContainerUtil.newHashSet();
        HashSet visitedSideEffectImports = ContainerUtil.newHashSet();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            Collection mergedImports;
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(info.getDeclaration().getImportModuleText())) continue;
                ES6ImportOptimizer.addSideEffectImport(file, importsResult, info);
                continue;
            }
            String fromText = ES6ImportOptimizer.getUnquotedFromClauseText(info.getDeclaration());
            if (fromText == null || !visitedImports.add(fromText) || (mergedImports = result.get((Object)fromText)).isEmpty()) continue;
            if (merge) {
                this.processMergedImports(file, importsResult, fromText, mergedImports);
                continue;
            }
            for (ES6UnusedImportsHelper.UnusedInfo mergedInfo : mergedImports) {
                importsResult.addAll(this.getImportBodyText(file, ContainerUtil.createMaybeSingletonList((Object)mergedInfo), fromText));
            }
        }
        ArrayList arrayList = importsResult;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        return arrayList;
    }

    protected void processMergedImports(@NotNull PsiFile file, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processMergedImports"));
        }
        importsResult.addAll(this.getImportBodyText(file, mergedImports, fromText));
    }

    private static void addSideEffectImport(@NotNull PsiFile file, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String name = declaration.getImportModuleText();
        if (!StringUtil.isEmpty((String)name)) {
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ES6ImportOptimizer.addFromPartWithoutKeyword(file, StringUtil.unquoteString((String)name), builder);
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        LinkedMultiMap results = new LinkedMultiMap();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportOptimizer.getUnquotedFromClauseText(declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        LinkedMultiMap linkedMultiMap = results;
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        return linkedMultiMap;
    }

    @Nullable
    private static String getUnquotedFromClauseText(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getUnquotedFromClauseText"));
        }
        ES6FromClause fromClause = declaration.getFromClause();
        if (fromClause == null) {
            return null;
        }
        String text = fromClause.getReferenceText();
        if (text != null) {
            return StringUtil.unquoteString((String)text);
        }
        return null;
    }

    private static boolean isSuppressedUnused(ES6ImportExportDeclaration declaration) {
        return SuppressionUtil.isSuppressedInStatement((PsiElement)declaration, (String)ES6UnusedImportsInspection.SHORT_NAME, ES6ImportDeclaration.class);
    }

    @NotNull
    protected List<String> getImportBodyText(PsiFile file, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, String fromPart) {
        ArrayList listOfImports = ContainerUtil.newArrayList();
        ArrayList prevComments = ContainerUtil.newArrayList();
        HashSet processedComments = ContainerUtil.newHashSet();
        StringBuilder importBody = new StringBuilder();
        LinkedHashSet toProcess = ContainerUtil.newLinkedHashSet();
        boolean needCommaBeforeBinding = false;
        boolean lastIsAll = false;
        HashSet names = ContainerUtil.newHashSet();
        String importPrefix = this.getImportPrefix(mergedImports);
        for (ES6UnusedImportsHelper.UnusedInfo importDeclaration : mergedImports) {
            ES6ImportDeclaration declaration = importDeclaration.getDeclaration();
            prevComments.addAll(ES6ImportOptimizer.getPrevComments(declaration).stream().map(el -> el.getText()).collect(Collectors.toList()));
            PsiElement comment = ES6ImportOptimizer.getLineComment(declaration);
            boolean isSuppressedUnused = ES6ImportOptimizer.isSuppressedUnused((ES6ImportExportDeclaration)declaration);
            Collection<Object> unusedBindings = isSuppressedUnused ? ContainerUtil.emptyList() : importDeclaration.getUnusedBindings();
            for (ES6ImportedBinding binding : declaration.getImportedBindings()) {
                if (unusedBindings.contains(binding) || !names.add(binding.getName())) continue;
                if (needCommaBeforeBinding) {
                    ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
                    ES6ImportOptimizer.addSameLineComments(importBody, ES6ImportOptimizer.getCommentsAsStrings(toProcess));
                    String resultText = importPrefix + importBody.toString();
                    listOfImports.add(resultText);
                    importBody.setLength(0);
                    processedComments.addAll(toProcess);
                    toProcess.clear();
                } else {
                    needCommaBeforeBinding = true;
                }
                if (comment != null) {
                    toProcess.add(comment);
                }
                importBody.append(binding.getText());
                lastIsAll = binding.isNamespaceImport();
            }
        }
        if (lastIsAll) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            ES6ImportOptimizer.addSameLineComments(importBody, ES6ImportOptimizer.getCommentsAsStrings(toProcess));
            listOfImports.add(importPrefix + importBody.toString());
            needCommaBeforeBinding = false;
            importBody.setLength(0);
            processedComments.addAll(toProcess);
            toProcess.clear();
        }
        names.clear();
        boolean needOpenSpecifierList = true;
        boolean needCommaBeforeSpecifier = false;
        for (ES6UnusedImportsHelper.UnusedInfo importDeclaration : mergedImports) {
            boolean isSuppressedUnused;
            ES6ImportDeclaration declaration = importDeclaration.getDeclaration();
            PsiElement comment = ES6ImportOptimizer.getLineComment(declaration);
            if (comment != null && !processedComments.contains(comment)) {
                toProcess.add(comment);
            }
            Collection<Object> unusedSpecifiers = (isSuppressedUnused = ES6ImportOptimizer.isSuppressedUnused((ES6ImportExportDeclaration)declaration)) ? ContainerUtil.emptyList() : importDeclaration.getUnusedSpecifiers();
            for (ES6ImportSpecifier specifier : declaration.getImportSpecifiers()) {
                String name;
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                String string = name = alias == null ? specifier.getReferenceName() : alias.getName();
                if (unusedSpecifiers.contains(specifier) || !names.add(name)) continue;
                if (needOpenSpecifierList) {
                    needOpenSpecifierList = false;
                    if (needCommaBeforeBinding) {
                        importBody.append(", ");
                    }
                    importBody.append('{');
                }
                if (needCommaBeforeSpecifier) {
                    importBody.append(", ");
                } else {
                    needCommaBeforeSpecifier = true;
                }
                importBody.append(specifier.getText());
            }
        }
        if (!needOpenSpecifierList) {
            importBody.append('}');
        }
        if (!StringUtil.isEmpty((CharSequence)importBody)) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            ES6ImportOptimizer.addSameLineComments(importBody, ES6ImportOptimizer.getCommentsAsStrings(toProcess));
            listOfImports.add(importPrefix + importBody.toString());
        }
        List list = ContainerUtil.concat((List)prevComments, (List)listOfImports);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        return list;
    }

    private static List<String> getCommentsAsStrings(Set<PsiElement> toProcess) {
        return toProcess.stream().map(el -> el.getText()).collect(Collectors.toList());
    }

    private static void addSameLineComments(@NotNull StringBuilder importBody, @NotNull Collection<String> sameLineComments) {
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSameLineComments"));
        }
        if (sameLineComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sameLineComments", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSameLineComments"));
        }
        if (!sameLineComments.isEmpty()) {
            importBody.append(" ");
            importBody.append(StringUtil.join(sameLineComments, (String)" "));
        }
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        if ("import " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        return "import ";
    }

    private static void addFromPart(PsiFile file, String fromPart, StringBuilder importBody) {
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(file, fromPart, importBody);
    }

    @NotNull
    private static List<PsiElement> getPrevComments(@NotNull ES6ImportDeclaration declaration) {
        PsiElement nextPrev;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getPrevComments"));
        }
        ArrayList comments = ContainerUtil.newArrayList();
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class});
        while (prev instanceof PsiComment && ((nextPrev = PsiTreeUtil.skipSiblingsBackward((PsiElement)prev, (Class[])new Class[]{PsiWhiteSpace.class})) == null || nextPrev instanceof PsiComment || !ES6ImportOptimizer.isSameLineElement(prev, nextPrev))) {
            comments.add(0, prev);
            prev = nextPrev;
        }
        ArrayList arrayList = comments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getPrevComments"));
        }
        return arrayList;
    }

    private static PsiElement getLineComment(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getLineComment"));
        }
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class});
        if (next instanceof PsiComment) {
            boolean isSameLineElements = ES6ImportOptimizer.isSameLineElement((PsiElement)declaration, next);
            return isSameLineElements ? next : null;
        }
        return null;
    }

    private static boolean isSameLineElement(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        int declarationLineNumber;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "isSameLineElement"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "isSameLineElement"));
        }
        Document document = PsiDocumentManager.getInstance((Project)startElement.getProject()).getDocument(startElement.getContainingFile());
        if (document == null) {
            return false;
        }
        int commentLineNumber = document.getLineNumber(endElement.getTextRange().getStartOffset());
        return commentLineNumber == (declarationLineNumber = document.getLineNumber(startElement.getTextRange().getEndOffset()));
    }

    private static void addFromPartWithoutKeyword(@NotNull PsiFile file, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        String quote = JSCodeStyleSettings.getQuote((PsiElement)file);
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(JSCodeStyleSettings.getSemicolon(file));
    }

    public static void deleteSiblingWhitespaceBetweenImports(PsiElement beforeElement, PsiElement after, boolean deleteBefore, boolean deleteAfter) {
        PsiElement sibling;
        if (deleteBefore) {
            sibling = beforeElement;
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                PsiElement prev = sibling.getPrevSibling();
                if (!ES6ImportOptimizer.prevIsAcceptable(prev)) continue;
                sibling.delete();
            }
        }
        if (deleteAfter) {
            sibling = after;
            while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                PsiElement nextSibling = sibling.getNextSibling();
                if (!ES6ImportOptimizer.nextIsAcceptable(nextSibling)) continue;
                sibling.delete();
            }
        }
    }

    public static boolean prevIsAcceptable(PsiElement prev) {
        return prev == null || prev instanceof ES6ImportDeclaration || prev instanceof PsiWhiteSpace || prev instanceof PsiComment;
    }

    public static boolean nextIsAcceptable(PsiElement prev) {
        return prev == null || prev instanceof ES6ImportDeclaration || prev instanceof PsiWhiteSpace;
    }
}

