/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddImportStatementFix
extends LocalQuickFixOnPsiElement
implements HintAction,
HighPriorityAction {
    private final String myName;

    public TypeScriptAddImportStatementFix(String name, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        super(context);
        this.myName = name;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeScriptAutoImportUtil.getActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "isAvailable"));
        }
        PsiElement element = this.getStartElement();
        List<JSQualifiedNamedElement> candidates = TypeScriptAddImportStatementFix.getCandidates(this.getNameElement(), element);
        return !candidates.isEmpty();
    }

    private static boolean checkReferenceExpressionAcceptable(JSReferenceExpression referenceExpression) {
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult result : results) {
            if (!result.isValidResult()) continue;
            hasValidResult = true;
            break;
        }
        return !hasValidResult;
    }

    @NotNull
    private static List<JSQualifiedNamedElement> getCandidates(String name, @Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        if (element instanceof JSReferenceExpression && !TypeScriptAddImportStatementFix.checkReferenceExpressionAcceptable((JSReferenceExpression)element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        if (name == null) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        Project project = element.getProject();
        TypeScriptAutoImportUtil.JSReferencePlaceInfo info = new TypeScriptAutoImportUtil.JSReferencePlaceInfo(element);
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)name, project, TypeScriptAutoImportUtil.createSymbolToImportSearchScope(element, project), JSElement.class, element1 -> {
            if (TypeScriptAutoImportUtil.isAvailableForImport(element1, info, project)) {
                result.add((JSQualifiedNamedElement)element1);
            }
            return true;
        });
        if (DialectDetector.isJSX(element)) {
            for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(element.getProject(), element)) {
                String moduleName = module.getName();
                if (moduleName == null || !StringUtil.unquoteString((String)moduleName).equalsIgnoreCase(name)) continue;
                result.add(module);
                break;
            }
        }
        List<JSQualifiedNamedElement> list = TypeScriptAddImportStatementFix.filterByContext(element, result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
        }
        return list;
    }

    private static List<JSQualifiedNamedElement> filterByContext(PsiElement context, List<JSQualifiedNamedElement> result) {
        if (result.isEmpty()) {
            return result;
        }
        if (context.getNode().getElementType() == JSTokenTypes.XML_TAG_NAME) {
            List exactComponents = ContainerUtil.emptyList();
            return result.stream().filter(el -> ReactXmlExtension.isPossibleReactComponent((PsiElement)el, exactComponents)).collect(Collectors.toList());
        }
        return result;
    }

    private String getNameElement() {
        return this.myName;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        new ImportAction(editor, this.getStartElement(), this.getNameElement()).execute();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        List<JSQualifiedNamedElement> candidates = TypeScriptAddImportStatementFix.getCandidates(this.getNameElement(), startElement);
        if (candidates.size() == 1) {
            TypeScriptAutoImportUtil.addImportStatement(this.myName, (JSQualifiedNamedElement)candidates.iterator().next(), startElement);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "showHint"));
        }
        if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport()) {
            return false;
        }
        PsiElement element = this.getStartElement();
        List<JSQualifiedNamedElement> candidates = TypeScriptAddImportStatementFix.getCandidates(this.getNameElement(), element);
        if (candidates.isEmpty()) {
            return true;
        }
        JSQualifiedNamedElement first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(candidates);
        assert (first != null);
        String nameToShow = new JSQualifiedNamedElementRenderer<JSQualifiedNamedElement>().getElementText(first) + " " + JSQualifiedNamedElementRenderer.getContainerText(first);
        String message = ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)nameToShow);
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)new ImportAction(editor, this.getStartElement(), this.getNameElement()));
        return true;
    }

    @NotNull
    private static List<JSQualifiedNamedElement> removeMergedElements(@NotNull List<JSQualifiedNamedElement> candidates, @NotNull Collection<JSQualifiedNamedElement> elementsFromLibraries) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
        }
        if (elementsFromLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
        }
        HashSet qNames = ContainerUtil.newHashSet();
        HashSet toRemove = ContainerUtil.newHashSet();
        for (JSQualifiedNamedElement candidate : candidates) {
            PsiElement module;
            String qName;
            if (elementsFromLibraries.contains(candidate) || StringUtil.isEmpty((String)(qName = JSQualifiedNamedElementRenderer.getQualifiedName(candidate))) || (module = TypeScriptPsiUtil.findExternalModule((PsiElement)candidate)) != null || qNames.add(qName)) continue;
            toRemove.add(candidate);
        }
        if (toRemove.isEmpty()) {
            List<JSQualifiedNamedElement> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
            }
            return list;
        }
        List<JSQualifiedNamedElement> list = candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
        }
        return list;
    }

    private static List<JSQualifiedNamedElement> removeSimilarLibraryModules(@NotNull List<JSQualifiedNamedElement> candidates, @NotNull Map<PsiElement, TypeScriptAutoImportUtil.ModuleInfo> calculatedModules) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeSimilarLibraryModules"));
        }
        if (calculatedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculatedModules", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeSimilarLibraryModules"));
        }
        if (calculatedModules.isEmpty() || calculatedModules.size() == 1) {
            return candidates;
        }
        HashSet toRemove = ContainerUtil.newHashSet();
        Set<Map.Entry<PsiElement, TypeScriptAutoImportUtil.ModuleInfo>> entries = calculatedModules.entrySet();
        ArrayList toIterate = ContainerUtil.newArrayList(calculatedModules.entrySet());
        HashSet uniqueModuleNames = ContainerUtil.newHashSet();
        entries.forEach(entry -> {
            TypeScriptAutoImportUtil.ModuleInfo moduleInfo = (TypeScriptAutoImportUtil.ModuleInfo)entry.getValue();
            VirtualFile pathFile = moduleInfo.getPathFile();
            PsiElement elementToImport = (PsiElement)entry.getKey();
            String pathText = pathFile.getPath();
            if (!StringUtil.isEmpty((String)pathText) && !uniqueModuleNames.add(pathText)) {
                toRemove.add(elementToImport);
            }
            if (pathFile.isDirectory()) {
                toIterate.forEach(second -> {
                    TypeScriptAutoImportUtil.ModuleInfo secondModuleInfo = (TypeScriptAutoImportUtil.ModuleInfo)second.getValue();
                    VirtualFile secondModuleInfoPathFile = secondModuleInfo.getPathFile();
                    if (secondModuleInfoPathFile.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)secondModuleInfoPathFile, (VirtualFile)pathFile, (boolean)true) && secondModuleInfoPathFile.findChild("package.json") != null) {
                        toRemove.add(elementToImport);
                    }
                });
            }
        });
        return candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
    }

    private static Collection<JSQualifiedNamedElement> getElementsFromLibraries(Collection<JSQualifiedNamedElement> candidates, Project project) {
        return candidates.stream().filter(element -> {
            PsiFile file = element.getContainingFile();
            if (file instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                VirtualFile fileToSearch = file.getVirtualFile();
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
                if (virtualFile != null) {
                    Pair<VirtualFile, VirtualFile> parentLibraryDirectory = TypeScriptAutoImportUtil.findParentLibraryDirectory(project, fileToSearch, JSLibraryUtil.LIBRARY_DIR_NAMES);
                    return parentLibraryDirectory != null;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static class ImportAction
    implements QuestionAction {
        @NotNull
        private final Editor myEditor;
        private final String myName;
        @Nullable
        private final PsiElement myStartElement;

        public ImportAction(@NotNull Editor editor, @Nullable PsiElement startElement, String name) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "<init>"));
            }
            this.myStartElement = startElement;
            this.myEditor = editor;
            this.myName = name;
        }

        public boolean execute() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myStartElement == null) {
                return true;
            }
            List candidates = TypeScriptAddImportStatementFix.getCandidates(this.myName, this.myStartElement);
            if (candidates.isEmpty()) {
                return true;
            }
            if (candidates.size() == 1) {
                this.addImport(candidates);
            } else {
                HashMap preRenderedQNames = ContainerUtil.newHashMap();
                Project project = this.myStartElement.getProject();
                Collection elementsFromLibraries = TypeScriptAddImportStatementFix.getElementsFromLibraries(candidates, project);
                PsiFile file = this.myStartElement.getContainingFile();
                if (elementsFromLibraries.isEmpty()) {
                    List<JSQualifiedNamedElement> finalElements = ImportAction.getFinalElementsList(project, file, candidates, elementsFromLibraries, preRenderedQNames);
                    if (finalElements.size() == 1) {
                        this.addImport(candidates);
                    } else {
                        this.showPopup(finalElements, preRenderedQNames);
                    }
                    return true;
                }
                Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
                    List newCandidates = (List)ReadAction.compute(() -> ImportAction.getFinalElementsList(project, file, candidates, elementsFromLibraries, preRenderedQNames));
                    TransactionGuard.submitTransaction((Disposable)project, () -> {
                        if (newCandidates.isEmpty() || !this.myStartElement.isValid()) {
                            return;
                        }
                        if (newCandidates.size() == 1) {
                            JSQualifiedNamedElement item = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)newCandidates);
                            assert (item != null);
                            if (!item.isValid()) {
                                return;
                            }
                            CommandProcessor.getInstance().executeCommand(item.getProject(), () -> TypeScriptAutoImportUtil.addImportStatement(this.myName, item, this.myStartElement), this.getClass().getName(), (Object)this);
                            return;
                        }
                        this.showPopup(newCandidates, preRenderedQNames);
                    });
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    calcModuleNamesAndShowPopupIfNecessary.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
                }
            }
            return true;
        }

        private void addImport(List<JSQualifiedNamedElement> candidates) {
            JSQualifiedNamedElement candidate = candidates.iterator().next();
            TypeScriptAutoImportUtil.addImportStatement(this.myName, candidate, this.myStartElement);
        }

        private static List<JSQualifiedNamedElement> getFinalElementsList(@NotNull Project project, @NotNull PsiFile file, @NotNull List<JSQualifiedNamedElement> candidates, @NotNull Collection<JSQualifiedNamedElement> elementsFromLibraries, @NotNull Map<PsiElement, String> renderedTexts) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (elementsFromLibraries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (renderedTexts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedTexts", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (!file.isValid() || project.isDisposed() || !project.isOpen()) {
                return ContainerUtil.emptyList();
            }
            candidates = TypeScriptAddImportStatementFix.removeMergedElements(candidates, elementsFromLibraries);
            if (elementsFromLibraries.isEmpty()) {
                return candidates;
            }
            HashMap modulesInfos = ContainerUtil.newHashMap();
            ImportAction.fillExternalModuleNames(project, modulesInfos, elementsFromLibraries, file, candidates);
            modulesInfos.forEach((el, info) -> {
                if (renderedTexts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedTexts", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "lambda$getFinalElementsList$4"));
                }
                renderedTexts.put((PsiElement)el, info.getPath());
            });
            return TypeScriptAddImportStatementFix.removeSimilarLibraryModules(candidates, modulesInfos);
        }

        private void showPopup(@NotNull List<JSQualifiedNamedElement> candidates, final @NotNull Map<PsiElement, String> preRenderedQNames) {
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "showPopup"));
            }
            if (preRenderedQNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preRenderedQNames", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "showPopup"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(new JSQualifiedNamedElement[candidates.size()])), (PsiElementListCellRenderer)new JSQualifiedNamedElementRenderer<JSQualifiedNamedElement>(){

                @Override
                protected String getContainerText(JSQualifiedNamedElement element, String name) {
                    String preRenderedQName = (String)preRenderedQNames.get(element);
                    if (!StringUtil.isEmpty((String)preRenderedQName)) {
                        return "(" + preRenderedQName + ")";
                    }
                    return super.getContainerText(element, name);
                }
            }, (String)JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]), (PsiElementProcessor)new PsiElementProcessor<JSQualifiedNamedElement>(){

                public boolean execute(@NotNull JSQualifiedNamedElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$2", "execute"));
                    }
                    CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$2", "lambda$execute$0"));
                        }
                        if (myStartElement == null || !myStartElement.isValid() || !element.isValid()) {
                            return;
                        }
                        TypeScriptAutoImportUtil.addImportStatement(myName, element, myStartElement);
                    }, this.getClass().getName(), (Object)this);
                    return false;
                }
            }).showInBestPositionFor(this.myEditor);
        }

        private static void fillExternalModuleNames(@NotNull Project project, @NotNull Map<PsiElement, TypeScriptAutoImportUtil.ModuleInfo> renderedText, @NotNull Collection<JSQualifiedNamedElement> elementsFromLibraries, @NotNull PsiFile file, @NotNull List<JSQualifiedNamedElement> candidates) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (renderedText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedText", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (elementsFromLibraries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (JSQualifiedNamedElement element : elementsFromLibraries) {
                TypeScriptAutoImportUtil.ModuleInfo nameToModule = TypeScriptAutoImportUtil.getExternalFileModuleName(project, element, (PsiElement)file);
                if (nameToModule == null) continue;
                renderedText.put((PsiElement)element, nameToModule);
            }
        }
    }
}

