/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.JSCommonReferenceContributor;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleFileReferenceSet
extends FileReferenceSet {
    public TypeScriptModuleFileReferenceSet(String reference, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet", "<init>"));
        }
        super(reference, element, startInElement, provider, false, false, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement host = this.getElement();
        String requiredModuleName = this.getPathString();
        boolean isRelative = requiredModuleName.startsWith(".");
        Project project = host.getProject();
        PsiFile file = host.getContainingFile().getOriginalFile();
        LinkedHashSet altResolveModules = ContainerUtil.newLinkedHashSet();
        if (!isRelative) {
            TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(file);
            TypeScriptModuleFileReferenceSet.addBaseUrlContext(config, file, altResolveModules);
            JSCommonReferenceContributor.addNodeModulesDirContexts(project, host, altResolveModules, this);
            TypeScriptModuleFileReferenceSet.addTypeNodeModules(config, host, altResolveModules);
            VirtualFile path = TypeScriptUtil.findFileByReferencePath(file, requiredModuleName, project);
            if (path != null) {
                String s = StringUtil.replaceChar((String)requiredModuleName, (char)'/', (char)'\\');
                for (int i = StringUtil.countChars((CharSequence)s, (char)'\\'); i > 0; --i) {
                    path = path.getParent();
                }
                PsiDirectory directory = this.getElement().getManager().findDirectory(path.getParent());
                if (directory != null) {
                    altResolveModules.add(directory);
                    LinkedHashSet linkedHashSet = altResolveModules;
                    if (linkedHashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet", "computeDefaultContexts"));
                    }
                    return linkedHashSet;
                }
            }
        }
        altResolveModules.addAll(super.computeDefaultContexts());
        LinkedHashSet linkedHashSet = altResolveModules;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet", "computeDefaultContexts"));
        }
        return linkedHashSet;
    }

    private static void addBaseUrlContext(TypeScriptConfig config, PsiFile file, Collection<PsiFileSystemItem> altResolveModules) {
        PsiDirectory urlPsiFile;
        VirtualFile url;
        if (config != null && (url = config.getBaseUrl()) != null && (urlPsiFile = file.getManager().findDirectory(url)) != null) {
            altResolveModules.add((PsiFileSystemItem)urlPsiFile);
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return new TypeScriptFileModuleReference(text, i, textRange, this);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new TypeScriptModuleFilesFilter(this.getContainingFile());
    }

    private static void addTypeNodeModules(@Nullable TypeScriptConfig configForPsiFile, PsiElement context, Collection<PsiFileSystemItem> altResolveModules) {
        VirtualFile toSearchDir = null;
        if (configForPsiFile != null) {
            toSearchDir = configForPsiFile.getConfigDirectory();
        }
        if (toSearchDir != null) {
            VirtualFile nodeModulesFile = toSearchDir.findChild("node_modules");
            if (nodeModulesFile == null) {
                nodeModulesFile = NodeModuleUtil.findUpClosestNodeModulesResolveRoot(toSearchDir);
            }
            JSCommonReferenceContributor.addTypesForNodeModulesDir(context, altResolveModules, nodeModulesFile);
        }
    }

    public static class TypeScriptModuleFilesFilter
    implements Condition<PsiFileSystemItem> {
        private final PsiFile myCurrentFile;

        public TypeScriptModuleFilesFilter(PsiFile currentFile) {
            this.myCurrentFile = currentFile.getOriginalFile();
        }

        public boolean value(PsiFileSystemItem item) {
            if (!(item instanceof PsiFile)) {
                return true;
            }
            PsiFile psiFile = (PsiFile)item;
            if (psiFile.isEquivalentTo((PsiElement)this.myCurrentFile)) {
                return false;
            }
            String name = psiFile.getName();
            for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
                if (!StringUtil.endsWithIgnoreCase((String)name, (String)extension)) continue;
                return true;
            }
            return false;
        }
    }
}

