/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPsiUtil {
    public static final Condition<PsiElement> IS_TS_MODULE = Conditions.instanceOf(TypeScriptModule.class);
    private static final String THIS_NAME = "this";

    @Nullable
    public static JSType getTypeFromDeclaration(StubBasedPsiElementBase element) {
        TypeScriptType resultType = TypeScriptPsiUtil.getStubOrPsiTypeElement(element);
        return resultType == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)resultType);
    }

    @Nullable
    public static JSClass getParentClass(@Nullable PsiElement element) {
        PsiElement secondParent;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSClass) {
            return (JSClass)parent;
        }
        if (parent instanceof TypeScriptObjectType && (secondParent = parent.getParent()) instanceof JSClass) {
            return (JSClass)secondParent;
        }
        return null;
    }

    public static boolean isAmbientDeclaration(@Nullable PsiElement element) {
        if (element instanceof JSAttributeListOwner) {
            while (element != null && !(element instanceof JSFile)) {
                if (TypeScriptPsiUtil.hasAmbientAttribute((JSAttributeListOwner)element)) {
                    return true;
                }
                element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, TypeScriptModule.class, JSFile.class});
            }
            if (element != null && DialectDetector.isTypeScriptDefinitionFile((PsiFile)((JSFile)element))) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAmbientAttribute(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "hasAmbientAttribute"));
        }
        if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isGlobalScopeAugmentation()) {
            return true;
        }
        JSAttributeList list = element.getAttributeList();
        return list != null && list.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isNamedTypeDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement;
    }

    public static boolean isNamedTypeContainerDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || TypeScriptPsiUtil.isNamespaceDefinition(element);
    }

    public static boolean isNamespaceDefinition(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportSpecifierAlias || element instanceof JSFile || element instanceof ES6ImportExportSpecifier || element instanceof TypeScriptGlobalModuleExportDeclaration;
    }

    @Nullable
    public static TypeScriptExportAssignment findExportAssignment(@NotNull PsiElement module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "findExportAssignment"));
        }
        if (!DialectDetector.isTypeScript(module)) {
            return null;
        }
        TypeScriptExportAssignment exportAssignment = null;
        if (module instanceof PsiFileImpl) {
            StubElement stub = ((PsiFileImpl)module).getStub();
            if (stub != null) {
                StubElement exportAssignmentStub = stub.findChildStubByType(TypeScriptElementTypes.EXPORT_ASSIGNMENT);
                if (exportAssignmentStub != null) {
                    exportAssignment = (TypeScriptExportAssignment)exportAssignmentStub.getPsi();
                }
            } else {
                exportAssignment = (TypeScriptExportAssignment)((PsiFileImpl)module).findChildByClass(TypeScriptExportAssignment.class);
            }
        } else if (module instanceof TypeScriptModuleImpl) {
            exportAssignment = (TypeScriptExportAssignment)((TypeScriptModuleImpl)module).getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.EXPORT_ASSIGNMENT);
        }
        return exportAssignment;
    }

    public static boolean isClassMember(JSParameter parameter) {
        return TypeScriptPsiUtil.isFieldParameter(parameter);
    }

    @Nullable
    public static String getNameFromIdentifier(@Nullable ASTNode identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            identifier = identifier.getFirstChildNode();
        }
        if (identifier == null) {
            return null;
        }
        if (JSTokenTypes.STRING_LITERALS.contains(identifier.getElementType())) {
            return StringUtil.unquoteString((String)identifier.getText());
        }
        return identifier.getText();
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getStubOrPsiTypeElement"));
        }
        return (TypeScriptType)ArrayUtil.getFirstElement((Object[])TypeScriptPsiUtil.getStubOrPsiTypeElements(element));
    }

    @NotNull
    public static TypeScriptType[] getStubOrPsiTypeElements(@NotNull StubBasedPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getStubOrPsiTypeElements"));
        }
        TypeScriptType[] typeScriptTypeArray = (TypeScriptType[])element.getStubOrPsiChildren(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY);
        if (typeScriptTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getStubOrPsiTypeElements"));
        }
        return typeScriptTypeArray;
    }

    public static boolean isTopLevelContainer(@Nullable PsiElement element) {
        return element instanceof JSFile || element instanceof TypeScriptModule;
    }

    public static boolean isTopLevelContainerMember(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isTopLevelContainerMember"));
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentOverDefaultAssignable(element);
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    public static boolean isTopLevelContainerMember(@NotNull JSQualifiedObjectStubBase<?> stubElement) {
        if (stubElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElement", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isTopLevelContainerMember"));
        }
        StubElement parentStub = stubElement.getParentStub();
        if (parentStub != null && parentStub.getStubType() == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            parentStub = parentStub.getParentStub();
        }
        if (parentStub != null && JSElementTypes.VAR_STATEMENTS.contains((IElementType)parentStub.getStubType())) {
            parentStub = parentStub.getParentStub();
        }
        IStubElementType type = parentStub != null ? parentStub.getStubType() : null;
        return type == JSStubElementTypes.TYPESCRIPT_MODULE || type == null;
    }

    public static PsiElement getParentOverDefaultAssignable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getParentOverDefaultAssignable"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Nullable
    public static PsiElement findExternalModule(PsiElement context) {
        JSElement container = ES6PsiUtil.getExportScope(context);
        while (container != null) {
            if (TypeScriptPsiUtil.isExternalModule((PsiElement)container)) {
                return container;
            }
            if (container instanceof PsiFile) {
                return null;
            }
            container = ES6PsiUtil.getExportScope((PsiElement)container);
        }
        return null;
    }

    public static boolean isAmbientModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isAmbientModule"));
        }
        return module.isGlobalScopeAugmentation() || !module.isInternal();
    }

    public static boolean isExternalModule(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isExternalModule"));
        }
        if (element instanceof JSFile) {
            return ((JSFile)element).isCommonJSModule();
        }
        return element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal();
    }

    public static boolean isModule(PsiElement element, boolean includeInternal) {
        return element instanceof JSFile && ((JSFile)element).isCommonJSModule() || element instanceof TypeScriptModule && (includeInternal || !((TypeScriptModule)element).isInternal());
    }

    public static boolean isAbstractElement(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isAbstractElement"));
        }
        JSAttributeList list = element.getAttributeList();
        if (list == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public static boolean referencesNamedTypeContainer(@NotNull ES6ImportExportSpecifier specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "referencesNamedTypeContainer"));
        }
        ResolveResult[] results = specifier.resolveOverAliases();
        if (results.length == 0) {
            return true;
        }
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForVariableDefinition(@NotNull JSTypeDeclarationOwner element, @Nullable PsiElement methodExpression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
        }
        PsiElement parent = methodExpression instanceof JSCallExpression ? methodExpression : (methodExpression == null ? null : methodExpression.getParent());
        boolean hasNew = parent instanceof JSNewExpression;
        PsiElement typeElement = element.getTypeElement();
        if (typeElement instanceof TypeScriptSingleType) {
            TypeScriptSingleType singleType;
            String qualifiedTypeName;
            TypeScriptTypeArgumentList typeArgumentsList = ((TypeScriptSingleType)typeElement).getTypeArguments();
            JSTypeDeclaration[] typeArguments = typeArgumentsList == null ? JSTypeDeclaration.EMPTY_ARRAY : typeArgumentsList.getTypeArguments();
            ArrayList genericArguments = null;
            if (typeArguments.length > 0) {
                genericArguments = ContainerUtil.newArrayList();
                for (JSTypeDeclaration argument : typeArguments) {
                    genericArguments.add(TypeScriptTypeParser.buildTypeFromTypeScript(argument));
                }
            }
            if ((qualifiedTypeName = (singleType = (TypeScriptSingleType)typeElement).getQualifiedTypeName()) == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
                }
                return list;
            }
            JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveTypeName(qualifiedTypeName, typeElement);
            if (!result.hasElements()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
                }
                return list;
            }
            ArrayList allSignatures = ContainerUtil.newArrayList();
            for (PsiElement psiElement : result.getElements()) {
                if (!(psiElement instanceof TypeScriptInterface)) continue;
                TypeScriptInterface interfaceElement = (TypeScriptInterface)psiElement;
                Collection<JSFunction> signatures = TypeScriptPsiUtil.getCallSignatures(interfaceElement, hasNew);
                if (genericArguments != null) {
                    JSTypeSubstitutor subs = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(interfaceElement.getTypeParameterList(), genericArguments);
                    for (JSFunction signature : signatures) {
                        allSignatures.add(new JSFunctionWithSubstitutor((JSFunctionItem)signature, subs));
                    }
                    continue;
                }
                allSignatures.addAll(signatures.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList()));
            }
            ArrayList arrayList = allSignatures;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
            }
            return arrayList;
        }
        if (typeElement instanceof JSFunction) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSFunctionWithSubstitutor[]{new JSFunctionWithSubstitutor((JSFunctionItem)typeElement, null)});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
            }
            return arrayList;
        }
        if (typeElement instanceof TypeScriptObjectType) {
            Collection<JSFunction> result = TypeScriptPsiUtil.getCallSignatures((TypeScriptObjectType)typeElement, hasNew);
            Collection collection = result.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
        }
        return list;
    }

    public static Collection<JSFunction> getCallSignatures(TypeScriptInterface interfaceToProcess, boolean isNew) {
        ArrayList result = ContainerUtil.newArrayList();
        Collection<JSClass<?>> parents = TypeScriptUtil.getNonStrictParents(interfaceToProcess, true);
        for (JSClass<?> interfaceType : parents) {
            TypeScriptPsiUtil.addCallSignatures(result, interfaceType.getMembers(), isNew);
        }
        return result;
    }

    @NotNull
    private static Collection<JSFunction> getCallSignatures(@NotNull TypeScriptObjectType type, boolean isNew) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getCallSignatures"));
        }
        ArrayList results = ContainerUtil.newArrayList();
        TypeScriptPsiUtil.addCallSignatures(results, Arrays.asList(type.getTypeMembers()), isNew);
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getCallSignatures"));
        }
        return arrayList;
    }

    private static void addCallSignatures(@NotNull List<JSFunction> result, @NotNull Iterable<? extends JSElement> members, boolean isNew) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "addCallSignatures"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "addCallSignatures"));
        }
        for (JSElement jSElement : members) {
            TypeScriptCallSignature callSignature;
            if (!(jSElement instanceof TypeScriptCallSignature) || (callSignature = (TypeScriptCallSignature)jSElement).isConstructor() != isNew) continue;
            result.add((JSFunction)callSignature);
        }
    }

    public static boolean isFieldParameter(@NotNull JSParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isFieldParameter"));
        }
        JSAttributeList list = parameter.getAttributeList();
        return list != null && (list.getExplicitAccessType() != null || list.hasModifier(JSAttributeList.ModifierType.READONLY));
    }

    public static boolean isThisParameter(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isThisParameter"));
        }
        return THIS_NAME.equals(parameter.getName());
    }

    @NotNull
    public static TypeScriptFunction getLastOverload(@NotNull TypeScriptFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getLastOverload"));
        }
        TypeScriptFunction currentFunction = function;
        TypeScriptFunction prev = null;
        if (!function.isOverloadDeclaration()) {
            TypeScriptFunction typeScriptFunction = function;
            if (typeScriptFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getLastOverload"));
            }
            return typeScriptFunction;
        }
        while (currentFunction != null) {
            prev = currentFunction;
            ASTNode astNode = TypeScriptFunctionImpl.getNextOverloadFunction((JSFunction)currentFunction);
            currentFunction = astNode != null ? (TypeScriptFunction)astNode.getPsi() : null;
        }
        TypeScriptFunction typeScriptFunction = prev;
        if (typeScriptFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getLastOverload"));
        }
        return typeScriptFunction;
    }

    @Nullable
    public static TypeScriptFunction getOverloadImplementation(@NotNull TypeScriptFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getOverloadImplementation"));
        }
        TypeScriptFunction overload = TypeScriptPsiUtil.getLastOverload(function);
        return overload != function && overload.isOverloadImplementation() ? overload : null;
    }

    public static Collection<TypeScriptFunction> getAllOverloads(@NotNull TypeScriptFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getAllOverloads"));
        }
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)function);
        if (function.getName() != null && containingClass instanceof TypeScriptInterfaceClass) {
            Object[] functions = ((TypeScriptInterfaceClass)containingClass).findFunctionsByNameAndKind(function.getName(), JSFunction.FunctionKind.SIMPLE);
            LinkedHashSet result = ContainerUtil.newLinkedHashSet((Object[])functions);
            result.remove(function);
            return result;
        }
        TypeScriptFunction overload = TypeScriptPsiUtil.getLastOverload(function);
        LinkedHashSet result = overload == function ? ContainerUtil.newLinkedHashSet() : ContainerUtil.newLinkedHashSet((Object[])new TypeScriptFunction[]{overload});
        result.addAll(overload.getOverloadDeclarations());
        result.remove(function);
        return result;
    }

    public static ResolveResult[] chooseOverloads(ResolveResult[] resolveResults) {
        ResolveResult resultWithLiteralArguments = null;
        for (ResolveResult result : resolveResults) {
            if (result.isValidResult()) {
                PsiElement element = result.getElement();
                if (element instanceof TypeScriptFunction) {
                    if (resultWithLiteralArguments != null) continue;
                    for (JSParameterListElement listElement : ((TypeScriptFunction)element).getParameters()) {
                        if (!(listElement.getTypeElement() instanceof TypeScriptStringLiteralType)) continue;
                        resultWithLiteralArguments = result;
                    }
                    continue;
                }
                return resolveResults;
            }
            return resolveResults;
        }
        ResolveResult result = resultWithLiteralArguments != null ? resultWithLiteralArguments : (ResolveResult)ArrayUtil.getFirstElement((Object[])resolveResults);
        return new ResolveResult[]{result};
    }

    public static boolean isImplementationAndOverloadFunction(PsiElement _element, PsiElement resolvedElement) {
        if (_element instanceof TypeScriptFunction && resolvedElement instanceof TypeScriptFunction) {
            TypeScriptFunction function = (TypeScriptFunction)_element;
            TypeScriptFunction resolvedFunction = (TypeScriptFunction)resolvedElement;
            if (resolvedFunction.isOverloadDeclaration() && function.isOverloadImplementation() && function.getOverloadDeclarations().contains(resolvedFunction)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getMemberName(@NotNull JSComputedPropertyNameOwner function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getMemberName"));
        }
        String name = function.getName();
        if (name == null) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets(function);
        }
        String string = name == null ? "" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getMemberName"));
        }
        return string;
    }

    public static boolean isLiteralModuleAugmentationName(@Nullable PsiElement element) {
        PsiElement parent;
        return element instanceof JSLiteralExpression && (parent = element.getParent()) instanceof TypeScriptModule && element.isEquivalentTo(((TypeScriptModule)parent).getNameIdentifier());
    }
}

