/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleReferenceStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.impl.TypeScriptModuleTextReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptExternalModuleReferenceImpl
extends JSStubElementImpl<TypeScriptExternalModuleReferenceStub>
implements TypeScriptExternalModuleReference,
StubBasedPsiElement<TypeScriptExternalModuleReferenceStub> {
    private PsiReference[] myReferences;

    public TypeScriptExternalModuleReferenceImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptExternalModuleReferenceImpl(TypeScriptExternalModuleReferenceStub element) {
        super(element, (IStubElementType)TypeScriptElementTypes.EXTERNAL_MODULE_REFERENCE);
    }

    public ASTNode findReferenceNode() {
        return this.getNode().findChildByType(JSTokenTypes.STRING_LITERAL);
    }

    public String getReferenceText() {
        TypeScriptExternalModuleReferenceStub stub = (TypeScriptExternalModuleReferenceStub)this.getStub();
        if (stub != null) {
            return stub.getReferenceText();
        }
        Pair<String, PsiElement> quotedStringWithLiteral = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        return quotedStringWithLiteral == null ? null : (String)quotedStringWithLiteral.first;
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length > 0 ? references[references.length - 1] : null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.myReferences == null) {
            this.myReferences = this.createReferences();
        }
        if (this.myReferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "getReferences"));
        }
        return this.myReferences;
    }

    @NotNull
    private PsiReference[] createReferences() {
        Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        if (pair == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = ES6PsiUtil.calcImportExportFromClauseReferences((PsiElement)this, null);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getSimpleExternalModuleReferences(@NotNull PsiElement owner, @NotNull String quotedRefText, int offset, boolean soft) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "getSimpleExternalModuleReferences"));
        }
        if (quotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotedRefText", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "getSimpleExternalModuleReferences"));
        }
        String requiredModuleName = FileUtilRt.toSystemIndependentName((String)StringUtil.unquoteString((String)quotedRefText));
        final Project project = owner.getProject();
        if (!StringUtil.startsWith((CharSequence)requiredModuleName, (CharSequence)"./") && !StringUtil.startsWith((CharSequence)requiredModuleName, (CharSequence)"../")) {
            JSReferenceSet referenceSet = new JSReferenceSet(owner, quotedRefText, offset, soft || !DialectDetector.isTypeScript(owner)){

                @Override
                protected JSTextReference createTextReference(String s, int offset, boolean methodRef) {
                    return new TypeScriptModuleTextReference(s, offset, methodRef, project, this);
                }
            };
            return referenceSet.getReferences();
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<PsiElement> multiResolve() {
        Collection<PsiElement> collection = ES6PsiUtil.resolveModuleReferences((PsiElement)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "multiResolve"));
        }
        return collection;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myReferences = null;
    }
}

