/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptAugmentationUtil {
    @NotNull
    public static Collection<PsiElement> getAugmentations(@NotNull PsiElement context, @NotNull Collection<PsiElement> modules) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "getAugmentations"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "getAugmentations"));
        }
        if (!DialectDetector.isTypeScript(context) || modules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "getAugmentations"));
            }
            return list;
        }
        Project project = context.getProject();
        Collection<TypeScriptModule> augmentationModules = TypeScriptUtil.getAllAugmentationModules(project, context);
        if (augmentationModules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "getAugmentations"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        VirtualFile scope = TypeScriptAugmentationUtil.getVirtualFile(context);
        for (TypeScriptModule augmentation : augmentationModules) {
            VirtualFile moduleFile = TypeScriptAugmentationUtil.getVirtualFile((PsiElement)augmentation);
            if (scope != null && moduleFile != null && !TypeScriptConfigService.Provider.isAccessible(project, scope, moduleFile)) continue;
            Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation(augmentation);
            for (PsiElement resolvedModule : elements) {
                if (!modules.contains(resolvedModule)) continue;
                result.add(augmentation);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "getAugmentations"));
        }
        return arrayList;
    }

    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "getVirtualFile"));
        }
        PsiFile file = element.getContainingFile();
        PsiFile originalFile = file.getOriginalFile();
        return originalFile.getVirtualFile();
    }

    @NotNull
    private static Collection<PsiElement> resolveAugmentation(@NotNull TypeScriptModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "resolveAugmentation"));
        }
        Collection<PsiElement> collection = ES6PsiUtil.resolveModuleReferences((PsiElement)module);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "resolveAugmentation"));
        }
        return collection;
    }

    public static boolean isExternalModuleAugmentation(@NotNull TypeScriptModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil", "isExternalModuleAugmentation"));
        }
        if (!TypeScriptPsiUtil.isAmbientModule(module)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)module);
        if (container instanceof JSFile) {
            return ((JSFile)container).isCommonJSModule();
        }
        if (container instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)container)) {
            JSElement secondLevelParent = ES6PsiUtil.getExportScope((PsiElement)container);
            return secondLevelParent != null && !TypeScriptPsiUtil.isExternalModule((PsiElement)secondLevelParent);
        }
        return false;
    }
}

