/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.extenders;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.JSDuplicatesProfile;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralSearchProfile2
extends StructuralSearchProfileBase {
    private static final TokenSet VARIABLE_DELIMETERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COMMA, JSTokenTypes.SEMICOLON});

    @NotNull
    protected String[] getVarPrefixes() {
        String[] stringArray = new String[]{"_$______"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/extenders/JSStructuralSearchProfile2", "getVarPrefixes"));
        }
        return stringArray;
    }

    @NotNull
    protected LanguageFileType getFileType() {
        LanguageFileType languageFileType = JavaScriptSupportLoader.JAVASCRIPT;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/extenders/JSStructuralSearchProfile2", "getFileType"));
        }
        return languageFileType;
    }

    @NotNull
    protected TokenSet getVariableDelimiters() {
        TokenSet tokenSet = VARIABLE_DELIMETERS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/extenders/JSStructuralSearchProfile2", "getVariableDelimiters"));
        }
        return tokenSet;
    }

    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaScriptCodeContextType.class;
    }

    @NotNull
    public Language getLanguage(PsiElement element) {
        Language language = JSDuplicatesProfile.getLanguageForElement(element);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/extenders/JSStructuralSearchProfile2", "getLanguage"));
        }
        return language;
    }

    protected String getContext(@NotNull String pattern, @Nullable Language language, String contextName) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/structuralsearch/extenders/JSStructuralSearchProfile2", "getContext"));
        }
        return language == JavaScriptSupportLoader.ECMA_SCRIPT_L4 ? "class A { function f() { $$PATTERN_PLACEHOLDER$$ } }" : super.getContext(pattern, language, contextName);
    }
}

