/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicNumberJSInspection
extends JavaScriptInspection {
    @NonNls
    private static final String[] s_specialCaseLiteralArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0L", "1L", "2L", "0l", "1l", "2l", "0.0", "1.0", "0.0F", "1.0F", "0.0f", "1.0f"};
    private static final Set<String> s_specialCaseLiterals = new HashSet<String>(23);

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("magic.number.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONFUSING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("magic.number.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection", "buildErrorString"));
        }
        return string;
    }

    static boolean isSpecialCaseLiteral(String text) {
        return s_specialCaseLiterals.contains(text);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MagicNumberVisitor();
    }

    private static boolean isNumeric(String text) {
        if (text.length() == 0) {
            return false;
        }
        char firstChar = text.charAt(0);
        return Character.isDigit(firstChar) || firstChar == '.';
    }

    private static boolean isDeclaredConstant(JSLiteralExpression expression) {
        JSVariable[] variables;
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSVarStatement.class);
        if (varStatement == null) {
            return false;
        }
        for (JSVariable variable : variables = varStatement.getVariables()) {
            if (!expression.equals(variable.getInitializer())) continue;
            JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
            if (containingFunction != null) {
                PsiElement parent = JSResolveUtil.findParent((PsiElement)containingFunction);
                if (parent instanceof JSClass) {
                    return false;
                }
                if (containingFunction instanceof JSFunctionExpression && !(parent instanceof JSParenthesizedExpression)) {
                    PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)variable);
                    if (docComment != null) {
                        final Ref result = new Ref();
                        JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                            @Override
                            public boolean needsPlainCommentData() {
                                return false;
                            }

                            @Override
                            public boolean onCommentLine(@NotNull String line) {
                                if (line == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection$1", "onCommentLine"));
                                }
                                return true;
                            }

                            @Override
                            public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                                if (type == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection$1", "onPatternMatch"));
                                }
                                if (line == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection$1", "onPatternMatch"));
                                }
                                if (patternMatched == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection$1", "onPatternMatch"));
                                }
                                if (type == JSDocumentationProcessor.MetaDocType.FINAL) {
                                    result.set((Object)Boolean.TRUE);
                                    return false;
                                }
                                return true;
                            }

                            @Override
                            public void postProcess() {
                            }
                        });
                        return result.get() != null;
                    }
                    return false;
                }
                if (!(containingFunction instanceof JSFunctionExpression || parent instanceof JSFile || parent instanceof JSPackageStatement)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static {
        for (String string : s_specialCaseLiteralArray) {
            s_specialCaseLiterals.add(string);
        }
    }

    private static class MagicNumberVisitor
    extends BaseInspectionVisitor {
        private MagicNumberVisitor() {
        }

        public void visitJSLiteralExpression(@NotNull JSLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection$MagicNumberVisitor", "visitJSLiteralExpression"));
            }
            super.visitJSLiteralExpression(expression);
            String text = expression.getText();
            if (text == null) {
                return;
            }
            if (!MagicNumberJSInspection.isNumeric(text)) {
                return;
            }
            if (MagicNumberJSInspection.isSpecialCaseLiteral(text)) {
                return;
            }
            if (MagicNumberJSInspection.isDeclaredConstant(expression)) {
                return;
            }
            if (MagicNumberVisitor.isPropertyValue(expression)) {
                return;
            }
            if (MagicNumberVisitor.radix16Argument(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof JSPrefixExpression) {
                this.registerError(parent);
            } else {
                this.registerError((PsiElement)expression);
            }
        }

        private static boolean radix16Argument(JSLiteralExpression expression) {
            PsiElement parent;
            if (!"16".equals(expression.getText().trim())) {
                return false;
            }
            JSLiteralExpression currentExpression = expression;
            while (currentExpression instanceof JSExpression) {
                currentExpression = currentExpression.getParent();
            }
            if (currentExpression instanceof JSArgumentList && (parent = currentExpression.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() instanceof JSReferenceExpression) {
                JSReferenceExpression methodExpression = (JSReferenceExpression)((JSCallExpression)parent).getMethodExpression();
                if (methodExpression.getQualifier() == null && "parseInt".equals(methodExpression.getReferenceName())) {
                    return true;
                }
                if (methodExpression.getQualifier() != null && "toString".equals(methodExpression.getReferenceName())) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isPropertyValue(JSLiteralExpression expression) {
            return expression.getParent() instanceof JSProperty && expression.equals(((JSProperty)expression.getParent()).getLiteralExpressionInitializer());
        }
    }
}

