/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.inline.InlineRefactoringActionHandler;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.dataflow.UnnecessaryLocalVariableJSInspectionBase;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableJSInspection
extends UnnecessaryLocalVariableJSInspectionBase {
    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return new InspectionJSFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                PsiElement parent;
                PsiElement element = descriptor.getPsiElement();
                PsiElement psiElement = parent = element != null ? element.getParent() : null;
                if (parent instanceof JSVariable) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                    PsiFile containingFile = parent.getContainingFile();
                    if (InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile) != null && !(editor instanceof EditorWindow)) {
                        editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)containingFile);
                    }
                    InlineRefactoringActionHandler.invokeInliner((Editor)editor, (PsiElement)parent);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionJSBundle.message("redundant.local.variable.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspection$1", "getFamilyName"));
                }
                return string;
            }
        };
    }
}

