/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryParenthesesChecker {
    public static boolean shouldRemove(@NotNull JSParenthesizedExpression expression) {
        int childPrecendence;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/utils/UnnecessaryParenthesesChecker", "shouldRemove"));
        }
        PsiElement expressionParent = expression.getParent();
        if (!(expressionParent instanceof JSElement)) {
            return false;
        }
        JSElement parent = (JSElement)expressionParent;
        JSExpression body = expression.getInnerExpression();
        if (!(parent instanceof JSExpression)) {
            return !(body instanceof JSCallExpression) || !(((JSCallExpression)body).getMethodExpression() instanceof JSFunctionExpression);
        }
        if (body instanceof JSParenthesizedExpression) {
            return true;
        }
        int parentPrecendence = ParenthesesUtils.getPrecendence((JSExpression)parent);
        if (parentPrecendence > (childPrecendence = ParenthesesUtils.getPrecendence(body))) {
            return !(body instanceof JSFunctionExpression);
        }
        if (parentPrecendence == childPrecendence) {
            if (parent instanceof JSBinaryExpression && body instanceof JSBinaryExpression) {
                IElementType parentOperator = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childOperator = ((JSBinaryExpression)body).getOperationSign();
                JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
                JSExpression lhs = binaryExpression.getLOperand();
                return lhs != null && lhs.equals(expression) && parentOperator.equals(childOperator);
            }
            return false;
        }
        return false;
    }
}

