/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReservedWordUsedAsNameJSInspection
extends JavaScriptInspection {
    @NonNls
    private static final Set<String> ourJSReserved = new THashSet();
    private static final Set<String> ourASReserved = new THashSet();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("reserved.word.used.as.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/ReservedWordUsedAsNameJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.VALIDITY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/ReservedWordUsedAsNameJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("reserved.word.used.as.name.error.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/ReservedWordUsedAsNameJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReservedWordAsNameVisitor();
    }

    static {
        ContainerUtil.addAll(ourJSReserved, (Object[])new String[]{"null", "true", "false", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
        ContainerUtil.addAll(ourASReserved, (Object[])new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "else", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "internal", "is", "native", "new", "null", "package", "private", "protected", "public", "return", "super", "switch", "this", "throw", "to", "true", "try", "typeof", "use", "var", "void", "while", "with", "each", "get", "set", "namespace", "include", "dynamic", "final", "native", "override", "static", "abstract", "boolean", "byte", "cast", "char", "debugger", "double", "enum", "export", "float", "goto", "intrinsic", "long", "prototype", "short", "synchronized", "throws", "to", "transient", "type", "virtual", "volatile"});
    }

    private static class ReservedWordAsNameVisitor
    extends BaseInspectionVisitor {
        boolean myEcma5 = false;
        boolean myActionScript = false;
        private DialectOptionHolder myDialectOptionHolder;

        private ReservedWordAsNameVisitor() {
        }

        @Override
        public void setProblemsHolder(ProblemsHolder problemsHolder) {
            super.setProblemsHolder(problemsHolder);
            this.myDialectOptionHolder = DialectDetector.dialectOfFile(problemsHolder.getFile());
            this.myEcma5 = JSRootConfiguration.getInstance(problemsHolder.getProject()).getLanguageLevel().isES5Compatible() && this.myDialectOptionHolder != null && this.myDialectOptionHolder.isJavaScript();
            this.myActionScript = this.myDialectOptionHolder != null && this.myDialectOptionHolder.isECMA4;
        }

        public void visitJSElement(JSElement node) {
            String name;
            PsiElement nameIdentifier;
            super.visitJSElement(node);
            if (node instanceof JSFunctionExpression && ((JSFunctionExpression)node).getOwnNameIdentifier() == null) {
                return;
            }
            if (this.myEcma5 && (node instanceof JSProperty || node instanceof JSFunction && (((JSFunction)node).isGetProperty() || ((JSFunction)node).isSetProperty()))) {
                return;
            }
            if (node instanceof JSDefinitionExpression) {
                if (this.myActionScript) {
                    return;
                }
                JSExpression expression = ((JSDefinitionExpression)node).getExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSReferenceExpression ref = (JSReferenceExpression)expression;
                    if (this.myEcma5 && ref.getQualifier() != null) {
                        return;
                    }
                    PsiElement resolve = ref.resolve();
                    if (resolve != null && !JSResolveUtil.isSameReference(ref, resolve)) {
                        return;
                    }
                }
            }
            if ((node instanceof ES6ExportSpecifierAlias || node instanceof ES6ExportedDefaultBinding) && "default".equals(node.getName())) {
                return;
            }
            if (node instanceof JSParameter && this.isTypeScript() && TypeScriptPsiUtil.isThisParameter((JSParameterItem)((JSParameter)node))) {
                return;
            }
            if (node instanceof JSNamedElement && (nameIdentifier = ((JSNamedElement)node).getNameIdentifier()) != null && this.isReserved(name = nameIdentifier.getText())) {
                this.registerError(nameIdentifier);
            }
        }

        private boolean isTypeScript() {
            return this.myDialectOptionHolder != null && this.myDialectOptionHolder.isTypeScript;
        }

        private boolean isReserved(String name) {
            return this.myActionScript ? ourASReserved.contains(name) : ourJSReserved.contains(name);
        }
    }
}

