/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.FileItem;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0000\u001a*\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a*\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"RENAME_SCORE", "", "cutOffWebpackFooter", "", "sourceContent", "resolveFileBySourceUrl", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "url", "_sourceContent", "selectMostSimilarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "", "sourceBytes", "", "findFileIfAsar", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "JavaScriptDebugger"})
public final class FileResolverByContentKt {
    private static final int RENAME_SCORE = 60;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile findFileIfAsar(@NotNull JavaScriptDebugProcess<?> $receiver, @NotNull Url url) {
        Collection files;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (!url.isInLocalFileSystem()) {
            return null;
        }
        String scriptPath = url.getPath();
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)SourceMapLoaderKt.ASAR, (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return null;
        }
        String string = scriptPath;
        int n = 0;
        int n2 = index + (SourceMapLoaderKt.ASAR.length() - 1);
        JavaScriptDebugProcess<?> javaScriptDebugProcess = $receiver;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        AsarFileSystem asarFileSystem = javaScriptDebugProcess.getAsarFs$JavaScriptDebugger(string4);
        if (asarFileSystem == null) {
            return null;
        }
        AsarFileSystem fs = asarFileSystem;
        String string5 = scriptPath;
        n2 = index + SourceMapLoaderKt.ASAR.length();
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        String scriptRelativePath = string7;
        FileItem fileItem = fs.getFile(scriptRelativePath);
        if (fileItem == null) {
            return null;
        }
        FileItem fileItem2 = fileItem;
        VirtualFile virtualFile = fs.getVfsRoot();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            VirtualFile it = virtualFile2;
            VirtualFile virtualFile3 = it.findFileByRelativePath(scriptRelativePath);
            if (virtualFile3 != null) {
                VirtualFile virtualFile4 = virtualFile3;
                VirtualFile it2 = virtualFile4;
                return it2;
            }
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)$receiver.getSession().getProject());
        Iterable $i$f$runReadAction = files = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>($receiver, scriptRelativePath, scope){
            final /* synthetic */ JavaScriptDebugProcess receiver$0$inlined;
            final /* synthetic */ String $scriptRelativePath$inlined;
            final /* synthetic */ GlobalSearchScope $scope$inlined;

            public final T compute() {
                return (T)FilenameIndex.getVirtualFilesByName((Project)this.receiver$0$inlined.getSession().getProject(), (String)PathUtilRt.getFileName((String)this.$scriptRelativePath$inlined), (GlobalSearchScope)this.$scope$inlined);
            }
            {
                this.receiver$0$inlined = javaScriptDebugProcess;
                this.$scriptRelativePath$inlined = string;
                this.$scope$inlined = globalSearchScope;
            }
        });
        if (!$i$f$runReadAction.isEmpty()) {
            void destination$iv;
            void $receiver$iv;
            $i$f$runReadAction = files;
            Collection it2 = (Collection)new SmartList();
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                String string8 = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it.path");
                if (!FileUtilKt.endsWithName((String)string8, (String)scriptRelativePath)) continue;
                destination$iv.add(element$iv);
            }
            Collection collection = files = destination$iv;
            if (!collection.isEmpty()) {
                return FileResolverByContentKt.selectMostSimilarFile$default(files, fs.loadBytes(fileItem2), null, 4, null);
            }
        }
        return null;
    }

    @Nullable
    public static final Url resolveFileBySourceUrl(@NotNull Project project, @NotNull Url url, @Nullable String _sourceContent) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String sourceContent = _sourceContent;
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"webpack")) {
            if (JavaScriptDebugProcessKt.isWebpackLibraryFile(url)) {
                return null;
            }
            if (sourceContent != null) {
                sourceContent = FileResolverByContentKt.cutOffWebpackFooter(sourceContent);
            }
        } else if ((Intrinsics.areEqual((Object)url.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)url.getScheme(), (Object)"https")) && (!url.isInLocalFileSystem() || Files.exists(Paths.get(url.getPath(), new String[0]), LinkOption.NOFOLLOW_LINKS))) {
            return null;
        }
        String fileName = PathUtilRt.getFileName((String)url.getPath());
        CharSequence charSequence = fileName;
        if (charSequence.length() > 0) {
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
            Collection files = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(project, fileName, scope){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $fileName$inlined;
                final /* synthetic */ GlobalSearchScope $scope$inlined;

                public final T compute() {
                    return (T)FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)this.$fileName$inlined, (GlobalSearchScope)this.$scope$inlined);
                }
                {
                    this.$project$inlined = project;
                    this.$fileName$inlined = string;
                    this.$scope$inlined = globalSearchScope;
                }
            });
            Object object = files;
            if (!object.isEmpty()) {
                object = sourceContent;
                if (!(object == null || object.length() == 0)) {
                    Collection collection = files;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"files");
                    String string = sourceContent;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, string, project);
                    if (virtualFile != null) {
                        object = virtualFile;
                        VirtualFile it = (VirtualFile)object;
                        return Urls.newLocalFileUrl((VirtualFile)it);
                    }
                } else if (files.size() == 1) {
                    return Urls.newLocalFileUrl((VirtualFile)((VirtualFile)CollectionsKt.first((Iterable)files)));
                }
            }
        }
        return null;
    }

    private static final String cutOffWebpackFooter(String sourceContent) {
        int footerIndex = StringsKt.indexOf$default((CharSequence)sourceContent, (String)"WEBPACK FOOTER", (int)0, (boolean)false, (int)6, null);
        if (footerIndex > 0 && sourceContent.length() - footerIndex < 300) {
            int lastNonSpaceIndex = -1;
            for (int i = footerIndex - 1; i > 0; --i) {
                char c = sourceContent.charAt(i);
                if (c == '/' || c == '*') {
                    lastNonSpaceIndex = i;
                    continue;
                }
                if (!CharsKt.isWhitespace((char)c)) break;
            }
            if (lastNonSpaceIndex > 0) {
                String string = sourceContent;
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, lastNonSpaceIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
        }
        return sourceContent;
    }

    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @NotNull String sourceContent, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)sourceContent, (String)"sourceContent");
        String string = sourceContent;
        Charset charset = null;
        boolean bl = true;
        Object var6_6 = null;
        Collection<? extends VirtualFile> collection = files;
        if (var6_6 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return FileResolverByContentKt.selectMostSimilarFile(collection, byArray2, project);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, String string, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectMostSimilarFile");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, string, project);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @NotNull byte[] sourceBytes, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)sourceBytes, (String)"sourceBytes");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        VirtualFile matchedFile = null;
        int lastMatchedScore = RENAME_SCORE;
        for (VirtualFile virtualFile : files) {
            int contentScore;
            int score;
            int n;
            void destination$iv;
            int maxScore$iv;
            int length = (int)virtualFile.getLength();
            int max = Math.max(sourceBytes.length, length);
            int min = Math.min(sourceBytes.length, length);
            if (min * 100 / max < RENAME_SCORE) continue;
            if (project != null) {
                if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(virtualFile, project){
                    final /* synthetic */ VirtualFile $file$inlined;
                    final /* synthetic */ Project $project$inlined;

                    public final T compute() {
                        return (T)Boolean.valueOf(JSMinifiedFileUtil.isFileMinified((VirtualFile)this.$file$inlined, (Project)this.$project$inlined));
                    }
                    {
                        this.$file$inlined = virtualFile;
                        this.$project$inlined = project;
                    }
                })).booleanValue()) continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile.contentsToByteArray(), (String)"file.contentsToByteArray()");
            boolean bl = false;
            int n2 = 4;
            Object var15_16 = null;
            if (var15_16 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: similarityScore");
            }
            if ((n2 & 4) != 0) {
                maxScore$iv = SimilarityIndexKt.MAX_SCORE;
            }
            if (Arrays.equals(sourceBytes, (byte[])destination$iv)) {
                n = maxScore$iv;
            } else {
                void sourceIndex;
                if ((SimilarityIndex)sourceIndex.element == null) {
                    sourceIndex.element = SimilarityIndexKt.SimilarityIndex(sourceBytes);
                }
                SimilarityIndex similarityIndex = (SimilarityIndex)sourceIndex.element;
                if (similarityIndex == null) {
                    Intrinsics.throwNpe();
                }
                n = SimilarityIndex.score$default(similarityIndex, SimilarityIndexKt.SimilarityIndex((byte[])destination$iv), 0, 2, null);
            }
            if ((score = ((contentScore = n) * 99 + 100) / 10000) <= lastMatchedScore) continue;
            matchedFile = virtualFile;
            lastMatchedScore = score;
        }
        return matchedFile;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, byte[] byArray, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectMostSimilarFile");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, byArray, project);
    }
}

