/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.LambdaInLineVisitor;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.SourceInfo;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"getFistBreakableElement", "Lcom/intellij/psi/PsiElement;", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "getLambdaPosition", "Lorg/jetbrains/debugger/SourceInfo;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "JavaScriptDebugger"})
public final class PsiVisitorKt {
    private static final PsiElement getFistBreakableElement(JSFunction function) {
        for (PsiElement psiChild = function.getFirstChild(); psiChild != null; psiChild = psiChild.getNextSibling()) {
            if (!(psiChild instanceof JSExpression)) continue;
            return psiChild;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SourceInfo getLambdaPosition(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Project project) {
        void lambdaPosition;
        Object object;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition position = xSourcePosition;
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        if (!(xBreakpointProperties instanceof JavaScriptLineBreakpointProperties)) {
            xBreakpointProperties = null;
        }
        if ((object = (JavaScriptLineBreakpointProperties)xBreakpointProperties) == null || (object = ((JavaScriptLineBreakpointProperties)((Object)object)).lambdaOrdinal) == null) {
            return null;
        }
        int myOrdinal = ((Number)object).intValue();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        PsiVisitors.visit((XSourcePosition)position, (Project)project, (PsiVisitors.Visitor)new LambdaInLineVisitor(myOrdinal, (Ref.ObjectRef)lambdaPosition){
            final /* synthetic */ int $myOrdinal;
            final /* synthetic */ Ref.ObjectRef $lambdaPosition;

            protected void process(@NotNull JSFunction element, @NotNull PsiElement firstBreakable) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)firstBreakable, (String)"firstBreakable");
                if (this.$myOrdinal == this.lambdaOrdinal) {
                    this.$lambdaPosition.element = this.createSourcePosition(firstBreakable);
                    this.isStopped = true;
                }
                int n = this.lambdaOrdinal;
                this.lambdaOrdinal = n + 1;
            }
            {
                this.$myOrdinal = $captured_local_variable$0;
                this.$lambdaPosition = $captured_local_variable$1;
            }
        });
        return (SourceInfo)lambdaPosition.element;
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$getFistBreakableElement(@NotNull JSFunction function) {
        return PsiVisitorKt.getFistBreakableElement(function);
    }
}

