/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.actions;

import com.google.common.base.CharMatcher;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

class ShowAsJsonAction
extends DumbAwareAction {
    private static final CharMatcher JSON_START_MATCHER = CharMatcher.is((char)'{');
    private static final Key<Integer> LINE_KEY = Key.create((String)"jsonFileToLogLineNumber");
    private static final Key<WeakReference<Editor>> EDITOR_REF_KEY = Key.create((String)"jsonFileToConsoleEditor");

    ShowAsJsonAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/debugger/actions/ShowAsJsonAction", "update"));
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean enabled = editor != null && e.getData(LangDataKeys.CONSOLE_VIEW) != null && new JsonLineExtractor(editor).has();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JsonLineExtractor jsonLineExtractor;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/debugger/actions/ShowAsJsonAction", "actionPerformed"));
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        JsonLineExtractor jsonLineExtractor2 = jsonLineExtractor = project == null || editor == null ? null : new JsonLineExtractor(editor);
        if (jsonLineExtractor == null || !jsonLineExtractor.has()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (ShowAsJsonAction.selectOpened(editor, jsonLineExtractor, fileEditorManager)) {
            return;
        }
        LightVirtualFile virtualFile = new LightVirtualFile(StringUtil.trimMiddle((String)jsonLineExtractor.getPrefix(), (int)50), (Language)JsonLanguage.INSTANCE, jsonLineExtractor.get());
        virtualFile.putUserData(LINE_KEY, (Object)jsonLineExtractor.getLine());
        virtualFile.putUserData(EDITOR_REF_KEY, new WeakReference<Editor>(editor));
        PsiFile file = PsiManager.getInstance((Project)project).findFile((VirtualFile)virtualFile);
        if (file == null) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file, true));
        virtualFile.setWritable(false);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)virtualFile, true);
    }

    private static boolean selectOpened(Editor editor, JsonLineExtractor jsonLineExtractor, FileEditorManager fileEditorManager) {
        for (FileEditor fileEditor : fileEditorManager.getAllEditors()) {
            WeakReference editorReference;
            Integer line;
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            VirtualFile file = FileDocumentManager.getInstance().getFile(textEditor.getEditor().getDocument());
            if (!(file instanceof LightVirtualFile) || (line = (Integer)LINE_KEY.get((UserDataHolder)file)) == null || line.intValue() != jsonLineExtractor.getLine() || SoftReference.dereference((Reference)(editorReference = (WeakReference)EDITOR_REF_KEY.get((UserDataHolder)file))) != editor) continue;
            fileEditorManager.openFile(file, true, true);
            return true;
        }
        return false;
    }

    private static final class JsonLineExtractor {
        private int start;
        private int end;
        private Document document;
        private int line;
        private int lineStart;

        private JsonLineExtractor(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/debugger/actions/ShowAsJsonAction$JsonLineExtractor", "<init>"));
            }
            this.start = -1;
            this.end = -1;
            this.line = -1;
            this.lineStart = -1;
            this.doCompute(editor);
        }

        public int getLine() {
            return this.line;
        }

        private void doCompute(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/debugger/actions/ShowAsJsonAction$JsonLineExtractor", "doCompute"));
            }
            SelectionModel model = editor.getSelectionModel();
            this.document = editor.getDocument();
            if (!model.hasSelection()) {
                int offset = editor.getCaretModel().getOffset();
                if (offset <= this.document.getTextLength()) {
                    this.line = this.document.getLineNumber(offset);
                    this.lineStart = this.document.getLineStartOffset(this.line);
                    this.getJsonString(this.document, this.document.getLineEndOffset(this.line));
                }
                return;
            }
            this.lineStart = model.getSelectionStart();
            int end = model.getSelectionEnd();
            this.line = this.document.getLineNumber(this.lineStart);
            if (this.line == this.document.getLineNumber(end)) {
                this.getJsonString(this.document, end);
            }
        }

        private void getJsonString(Document document, int lineEnd) {
            CharSequence documentChars = document.getCharsSequence();
            int start = JSON_START_MATCHER.indexIn(documentChars, this.lineStart);
            if (start < 0) {
                return;
            }
            int end = -1;
            for (int i = lineEnd - 1; i > start; --i) {
                if (documentChars.charAt(i) != '}') continue;
                end = i;
                break;
            }
            if (end == -1) {
                return;
            }
            this.start = start;
            this.end = end + 1;
        }

        public CharSequence get() {
            return this.document.getCharsSequence().subSequence(this.start, this.end + 1);
        }

        public boolean has() {
            return this.start != -1;
        }

        public String getPrefix() {
            char c;
            CharSequence chars = this.document.getCharsSequence();
            int end = this.start;
            for (int i = this.start - 1; i > this.lineStart && ((c = chars.charAt(i)) == ':' || Character.isWhitespace(c)); --i) {
                --end;
            }
            return CharMatcher.WHITESPACE.trimFrom(chars.subSequence(this.lineStart, end));
        }
    }
}

