/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessStateBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggableRunConfiguration;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/execution/DebuggableProcessState;", "T", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessStateBase;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "inputPath", "", "getInputPath", "()Ljava/lang/String;", "addInputPathArg", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configureCommandLine", "debugPort", "", "configureEnvironment", "createProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "startProcess", "Lorg/jetbrains/concurrency/Promise;", "JavaScriptDebugger"})
public abstract class DebuggableProcessState<T extends DebuggableProcessRunConfiguration>
extends DebuggableProcessStateBase<T> {
    @NotNull
    protected String getInputPath() {
        String string = ((DebuggableProcessRunConfiguration)this.getConfiguration()).getInputPath();
        if (string == null) {
            throw (Throwable)new ExecutionException("Program input path not specified");
        }
        String inputPath = string;
        if (ScriptFileUtil.isMemoryScriptPath((String)inputPath)) {
            String string2 = inputPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputPath");
            return string2;
        }
        String string3 = FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.getEnvironment().getProject())).expandPath(inputPath));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtilRt.toSystemDepen\u2026t).expandPath(inputPath))");
        return string3;
    }

    @Override
    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        String string = ((DebuggableProcessRunConfiguration)this.getConfiguration()).getEffectiveExePath();
        if (string == null) {
            throw (Throwable)new ExecutionException("Program path not specified");
        }
        String exePath = string;
        commandLine.setExePath(((DebuggableProcessRunConfiguration)this.getConfiguration()).correctExePath(exePath));
        String string2 = ((DebuggableProcessRunConfiguration)this.getConfiguration()).getEffectiveWorkingDirectory();
        if (string2 != null) {
            String string3 = string2;
            String it = string3;
            commandLine.withWorkDirectory(it);
        }
        this.configureCommandLine(commandLine, debugPort);
        this.configureEnvironment(commandLine);
        ProcessHandler processHandler = this.createProcessHandler(commandLine, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.getEnvironment().getProject());
        Promise promise = Promise.resolve((Object)processHandler);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.resolve(processHandler)");
        return promise;
    }

    protected void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        commandLine.withEnvironment(((DebuggableProcessRunConfiguration)this.getConfiguration()).getEnvs());
        commandLine.withParentEnvironmentType(((DebuggableProcessRunConfiguration)this.getConfiguration()).isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    protected final void addInputPathArg(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        commandLine.addParameters(new String[]{this.getInputPath()});
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return (ProcessHandler)new OSProcessHandler(commandLine);
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
    }

    public DebuggableProcessState(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        super((DebuggableRunConfiguration)configuration, environment);
    }
}

