/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.xdebugger.XDebuggerManager;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.FileResponses;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapDetectorFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "JavaScriptDebugger"})
final class SourceMapDetectorFileHandler
extends WebServerFileHandler {
    /*
     * WARNING - void declaration
     */
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        void $receiver$iv;
        JavaScriptDebugProcess debugProcess2;
        int n;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        Path file = pathInfo.getIoFile();
        if (file == null || !StringsKt.endsWith((String)((Object)file.getFileName()).toString(), (String)".js", (boolean)true)) {
            return false;
        }
        List debugProcesses = XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class);
        if (debugProcesses.isEmpty()) {
            return false;
        }
        String string2 = SourceMapLoaderKt.getSourceMapUrl(file);
        if (string2 == null) {
            return false;
        }
        String sourceMapUrl = string2;
        String string3 = NettyKt.getHost((HttpRequest)((HttpRequest)request));
        if (string3 == null) {
            return false;
        }
        String host = string3;
        Url scriptUrl = Urls.newUrl((String)NettyKt.getUriScheme((Channel)channel), (String)host, (String)WebServerFileHandlerKt.getRequestPath((CharSequence)canonicalPath, (String)projectNameIfNotCustomHost));
        Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, scriptUrl);
        if (!JsFileUtil.isOnBuiltInWebServer(parsedUrl)) {
            return false;
        }
        String path = parsedUrl.getPath();
        if (projectNameIfNotCustomHost == null) {
            string = path;
            n = 1;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            path = string5;
        } else if (path.length() > projectNameIfNotCustomHost.length() + 1 && StringsKt.startsWith$default((String)path, (String)projectNameIfNotCustomHost, (int)1, (boolean)false, (int)4, null) && path.charAt(projectNameIfNotCustomHost.length() + 1) == '/') {
            string = path;
            n = projectNameIfNotCustomHost.length() + 1;
            String string6 = string;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            path = string7;
        } else {
            void $receiver$iv2;
            Exception e$iv;
            Logger logger = JavaScriptDebugProcessKt.getLOG();
            Object var16_18 = null;
            boolean bl = true;
            Object var18_22 = null;
            if (var18_22 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debug");
            }
            if (bl & true) {
                e$iv = null;
            }
            if ($receiver$iv2.isDebugEnabled()) {
                void var21_24 = $receiver$iv2;
                String string8 = "SourceMap " + parsedUrl + " doesn't belong to current project " + projectNameIfNotCustomHost;
                var21_24.debug(string8, (Throwable)e$iv);
            }
            return false;
        }
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        String string9 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"path");
        Object object = WebServerPathToFileManager.getPathInfo$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string9, (boolean)false, (int)2, null);
        if (object == null || (object = object.getIoFile()) == null) {
            return false;
        }
        Object sourceMapFile = object;
        CharSequence sourceMapData = PathKt.readChars((Path)sourceMapFile);
        SmartList promises = new SmartList();
        for (JavaScriptDebugProcess debugProcess2 : debugProcesses) {
            SourceMap sourceMap;
            if (debugProcess2.isFilesOnlyInLocalFileSystem()) continue;
            PreloadedSourceMapList preloadedSourceMapList = debugProcess2.getPreloadedSourceMaps();
            Url url = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"scriptUrl");
            if (preloadedSourceMapList.containsScript(url)) continue;
            Url url2 = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"scriptUrl");
            if (JavaScriptDebugProcess.decodeSourceMap$default(debugProcess2, sourceMapData, url2, true, null, true, 8, null) == null) {
                continue;
            }
            PreloadedSourceMapList preloadedSourceMapList2 = debugProcess2.getPreloadedSourceMaps();
            Url url3 = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)url3, (String)"scriptUrl");
            if (!preloadedSourceMapList2.add(parsedUrl, sourceMap, url3)) continue;
            Vm vm = debugProcess2.getMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            debugProcess2.sourceMapFound(vm, sourceMap, null, scriptUrl, (List)promises);
        }
        debugProcess2 = Promises.all((Collection)((Collection)promises));
        void v15 = $receiver$iv;
        if (v15 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Promise)v15).processed((Consumer)new Consumer<Object>(request, channel, file, extraHeaders){
            final /* synthetic */ FullHttpRequest $request$inlined;
            final /* synthetic */ Channel $channel$inlined;
            final /* synthetic */ Path $file$inlined;
            final /* synthetic */ HttpHeaders $extraHeaders$inlined;

            public final void consume(Object it) {
                FileResponses.INSTANCE.sendFile((HttpRequest)this.$request$inlined, this.$channel$inlined, this.$file$inlined, this.$extraHeaders$inlined);
            }
            {
                this.$request$inlined = fullHttpRequest;
                this.$channel$inlined = channel;
                this.$file$inlined = path;
                this.$extraHeaders$inlined = httpHeaders;
            }
        }), (String)"(this as Promise<Any?>).processed({ handler() })");
        return true;
    }
}

