/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.sourcemap.MySourceEntriesProcessor;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceEntriesProcessor;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.javascript.debugger.FileUrlMapperSourceResolver;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0000\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001ad\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0015\u001a\u00020\u000f\u001aR\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\r\u001a:\u0010\u0018\u001a\u00020\u00192\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001ad\u0010\u0018\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u001c\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"createResolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRawLocations", "", "Lorg/jetbrains/debugger/Location;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "sourceUrls", "Lcom/intellij/util/Url;", "sourceLine", "", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "sourceColumn", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "processMappingsInLine", "", "entryProcessor", "Lcom/intellij/javascript/debugger/sourcemap/SourceEntriesProcessor;", "resolver", "localFileUrlOnly", "", "JavaScriptDebugger"})
public final class SourceMapHelperKt {
    @NotNull
    public static final List<Location> getRawLocations(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull List<? extends Url> sourceUrls, @NotNull XSourcePosition sourcePosition2, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        VirtualFile virtualFile = sourcePosition2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
        return SourceMapHelperKt.getRawLocations$default(debugProcess, sourceUrls, virtualFile, sourcePosition2.getLine(), map, script, scriptUrl, 0, 128, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getRawLocations$default(JavaScriptDebugProcess javaScriptDebugProcess, List list, XSourcePosition xSourcePosition, SourceMap sourceMap, Script script, Url url, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRawLocations");
        }
        if ((n & 8) != 0) {
            sourceMap = null;
        }
        if ((n & 0x10) != 0) {
            script = null;
        }
        if ((n & 0x20) != 0) {
            url = null;
        }
        return SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, list, xSourcePosition, sourceMap, script, url);
    }

    @NotNull
    public static final List<Location> getRawLocations(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull List<? extends Url> sourceUrls, @NotNull VirtualFile sourceFile, int sourceLine, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, int sourceColumn) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        MySourceEntriesProcessor processor2 = new MySourceEntriesProcessor(sourceColumn);
        if (map != null && (script != null || scriptUrl != null)) {
            SourceEntriesProcessor sourceEntriesProcessor = processor2;
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            SourceMapHelperKt.processMappingsInLine(sourceEntriesProcessor, map, script, sourceUrls, sourceLine, sourceFile, SourceMapHelperKt.createResolver(project, sourceFile), scriptUrl, debugProcess.isFilesOnlyInLocalFileSystem());
        } else {
            SourceMapHelperKt.processMappingsInLine(debugProcess, sourceUrls, sourceFile, sourceLine, processor2);
        }
        if (processor2.getLineToFirstMapping() == null) {
            return CollectionsKt.emptyList();
        }
        SmartList locations = new SmartList();
        LinkedHashMap<Object, TIntObjectHashMap<MappingEntry>> linkedHashMap = processor2.getLineToFirstMapping();
        if (linkedHashMap == null) {
            Intrinsics.throwNpe();
        }
        Iterator<Map.Entry<Object, TIntObjectHashMap<MappingEntry>>> iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TIntObjectHashMap<MappingEntry>> entry;
            Map.Entry<Object, TIntObjectHashMap<MappingEntry>> entry2 = entry = iterator.next();
            Object key = entry2.getKey();
            Map.Entry<Object, TIntObjectHashMap<MappingEntry>> entry3 = entry;
            TIntObjectHashMap<MappingEntry> value = entry3.getValue();
            int[] lines = value.keys();
            Arrays.sort(lines);
            for (int i = 0; i < lines.length; ++i) {
                int line = lines[i];
                MappingEntry mapping = (MappingEntry)value.get(line);
                if (key instanceof Script) {
                    locations.add((Object)new Location((Script)key, mapping.getGeneratedLine(), mapping.getGeneratedColumn()));
                    continue;
                }
                Object object = key;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                locations.add((Object)new Location((Url)object, mapping.getGeneratedLine(), mapping.getGeneratedColumn()));
            }
        }
        return (List)locations;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getRawLocations$default(JavaScriptDebugProcess javaScriptDebugProcess, List list, VirtualFile virtualFile, int n, SourceMap sourceMap, Script script, Url url, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRawLocations");
        }
        if ((n3 & 0x10) != 0) {
            sourceMap = null;
        }
        if ((n3 & 0x20) != 0) {
            script = null;
        }
        if ((n3 & 0x40) != 0) {
            url = null;
        }
        if ((n3 & 0x80) != 0) {
            n2 = -1;
        }
        return SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, list, virtualFile, n, sourceMap, script, url, n2);
    }

    public static final void processMappingsInLine(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull List<? extends Url> sourceUrls, @NotNull VirtualFile sourceFile, int sourceLine, @NotNull SourceEntriesProcessor entryProcessor) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)entryProcessor, (String)"entryProcessor");
        Project project = debugProcess.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        Lazy<SourceFileResolver> resolverLazyValue = SourceMapHelperKt.createResolver(project, sourceFile);
        PreloadedSourceMapList preloadedSourceMaps = debugProcess.getPreloadedSourceMaps();
        preloadedSourceMaps.process((TObjectObjectProcedure<Url, SourceMap>)((TObjectObjectProcedure)new TObjectObjectProcedure<Url, SourceMap>(entryProcessor, sourceUrls, sourceLine, sourceFile, resolverLazyValue, debugProcess){
            final /* synthetic */ SourceEntriesProcessor $entryProcessor;
            final /* synthetic */ List $sourceUrls;
            final /* synthetic */ int $sourceLine;
            final /* synthetic */ VirtualFile $sourceFile;
            final /* synthetic */ Lazy $resolverLazyValue;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;

            public final boolean execute(Url url, SourceMap map) {
                this.$entryProcessor.setScriptUrl(url);
                map.processSourceMappingsInLine(this.$sourceUrls, this.$sourceLine, (MappingsProcessorInLine)this.$entryProcessor, this.$sourceFile, this.$resolverLazyValue, this.$debugProcess.isFilesOnlyInLocalFileSystem());
                this.$entryProcessor.setScriptUrl(null);
                return true;
            }
            {
                this.$entryProcessor = sourceEntriesProcessor;
                this.$sourceUrls = list;
                this.$sourceLine = n;
                this.$sourceFile = virtualFile;
                this.$resolverLazyValue = lazy;
                this.$debugProcess = javaScriptDebugProcess;
            }
        }));
        debugProcess.forEachScript((Function1<Script, Boolean>)((Function1)new Function1<Script, Boolean>(preloadedSourceMaps, entryProcessor, sourceUrls, sourceLine, sourceFile, resolverLazyValue, debugProcess){
            final /* synthetic */ PreloadedSourceMapList $preloadedSourceMaps;
            final /* synthetic */ SourceEntriesProcessor $entryProcessor;
            final /* synthetic */ List $sourceUrls;
            final /* synthetic */ int $sourceLine;
            final /* synthetic */ VirtualFile $sourceFile;
            final /* synthetic */ Lazy $resolverLazyValue;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;

            public final boolean invoke(@NotNull Script script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                SourceMap map = script.getSourceMap();
                if (map != null && !this.$preloadedSourceMaps.containsMap(map)) {
                    SourceMapHelperKt.processMappingsInLine$default(this.$entryProcessor, map, script, this.$sourceUrls, this.$sourceLine, this.$sourceFile, this.$resolverLazyValue, null, this.$debugProcess.isFilesOnlyInLocalFileSystem(), 64, null);
                }
                return true;
            }
            {
                this.$preloadedSourceMaps = preloadedSourceMapList;
                this.$entryProcessor = sourceEntriesProcessor;
                this.$sourceUrls = list;
                this.$sourceLine = n;
                this.$sourceFile = virtualFile;
                this.$resolverLazyValue = lazy;
                this.$debugProcess = javaScriptDebugProcess;
                super(1);
            }
        }));
    }

    private static final void processMappingsInLine(@NotNull SourceEntriesProcessor $receiver, SourceMap map, Script script, List<? extends Url> sourceUrls, int sourceLine, VirtualFile sourceFile, Lazy<? extends SourceFileResolver> resolver, Url scriptUrl, boolean localFileUrlOnly) {
        Url url = scriptUrl;
        if (url == null) {
            Script script2 = script;
            if (script2 == null) {
                Intrinsics.throwNpe();
            }
            url = script2.getUrl();
        }
        $receiver.setScriptUrl(url);
        $receiver.setScript(script);
        map.processSourceMappingsInLine(sourceUrls, sourceLine, (MappingsProcessorInLine)$receiver, sourceFile, resolver, localFileUrlOnly);
        $receiver.setScriptUrl(null);
        $receiver.setScript(null);
    }

    static /* bridge */ /* synthetic */ void processMappingsInLine$default(SourceEntriesProcessor sourceEntriesProcessor, SourceMap sourceMap, Script script, List list, int n, VirtualFile virtualFile, Lazy lazy, Url url, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processMappingsInLine");
        }
        if ((n2 & 0x40) != 0) {
            url = null;
        }
        SourceMapHelperKt.processMappingsInLine(sourceEntriesProcessor, sourceMap, script, list, n, virtualFile, (Lazy<? extends SourceFileResolver>)lazy, url, bl);
    }

    @Nullable
    public static final Lazy<SourceFileResolver> createResolver(@NotNull Project project, @NotNull VirtualFile sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<createResolver.1.1.1>(sourceFile, project){
            final /* synthetic */ VirtualFile $sourceFile;
            final /* synthetic */ Project $project;

            @Nullable
            public final createResolver.1.1.1 invoke() {
                createResolver.1.1.1 v1;
                block3: {
                    Object[] $receiver$iv = FileUrlMapper.EP_NAME.getExtensions();
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        createResolver.1.1.1 result$iv;
                        createResolver.1.1.1 v0;
                        Object file$iv = $receiver$iv[i];
                        FileUrlMapper it = (FileUrlMapper)file$iv;
                        if (it.createSourceResolver(this.$sourceFile, this.$project) != null) {
                            FileUrlMapperSourceResolver fileUrlMapperSourceResolver;
                            FileUrlMapperSourceResolver it2 = fileUrlMapperSourceResolver;
                            v0 = (createResolver.1.1.1)new SourceFileResolver(it2, this){
                                final /* synthetic */ FileUrlMapperSourceResolver $it;
                                final /* synthetic */ createResolver.1 this$0;

                                public int resolve(VirtualFile sourceFile, ObjectIntHashMap<Url> map) {
                                    return this.$it.resolve(map, this.this$0.$project);
                                }
                                {
                                    this.$it = $captured_local_variable$1;
                                    this.this$0 = var2_2;
                                }
                            };
                        } else {
                            v0 = result$iv = null;
                        }
                        if (result$iv == null) continue;
                        v1 = result$iv;
                        break block3;
                    }
                    v1 = null;
                }
                return v1;
            }
            {
                this.$sourceFile = virtualFile;
                this.$project = project;
                super(0);
            }
        }));
    }
}

