/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebuggerUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0015\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u001a\u0017\u0010\u0010\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"EDITOR_MARKED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createSourceFromProvidedContent", "Lcom/intellij/openapi/vfs/VirtualFile;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "url", "Lcom/intellij/util/Url;", "script", "Lcom/intellij/openapi/util/UserDataHolder;", "getFileTitle", "", "file", "getSourceFile", "Lorg/jetbrains/annotations/Nullable;", "source", "setupEditor", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "JavaScriptDebugger"})
public final class SourceMapInspectorKt {
    private static final Key<Boolean> EDITOR_MARKED = Key.create((String)"marked");

    @Nullable
    public static final VirtualFile getSourceFile(@NotNull Url source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return LocalFileFinder.findFile((String)source.getPath());
    }

    @NotNull
    public static final String getFileTitle(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return JsFileUtil.trimTitle(FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl()));
    }

    @Nullable
    public static final VirtualFile createSourceFromProvidedContent(@NotNull SourceMap map, @NotNull Url url, @NotNull UserDataHolder script) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        int sourceIndex = map.getSourceResolver().getSourceIndex(url);
        String string = map.getSourceResolver().getSourceContent(sourceIndex);
        if (string == null) {
            return null;
        }
        String content = string;
        return ScriptsKt.createVmFile(url, script, content, sourceIndex);
    }

    private static final void setupEditor(EditorEx editor) {
        editor.setRendererMode(true);
        editor.getSettings().setLineNumbersShown(true);
        XDebuggerUtil.getInstance().disableValueLookup((Editor)editor);
    }

    public static final /* synthetic */ void access$setupEditor(@NotNull EditorEx editor) {
        SourceMapInspectorKt.setupEditor(editor);
    }

    @NotNull
    public static final /* synthetic */ Key access$getEDITOR_MARKED$p() {
        return EDITOR_MARKED;
    }
}

