/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPatternContainer;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopPsiTypePatternsUtil;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopBinaryExpression
extends AopElementBase
implements PsiPointcutExpression,
AopTypeExpression {
    public AopBinaryExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopBinaryExpression", "<init>"));
        }
        super(node);
    }

    @Nullable
    public final Pair<AopPatternContainer, AopPatternContainer> getOperands() {
        AopPatternContainer[] containers = (AopPatternContainer[])this.findChildrenByClass(AopPatternContainer.class);
        if (containers.length != 2) {
            return null;
        }
        return Pair.create((Object)containers[0], (Object)containers[1]);
    }

    @NotNull
    public AopOperation getOperation() {
        AopOperation aopOperation = this.findChildByType(AopElementTypes.AOP_OR) != null ? AopOperation.OR : AopOperation.AND;
        if (aopOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "getOperation"));
        }
        return aopOperation;
    }

    @Nullable
    public PsiElement getOpToken() {
        PsiElement or = this.findChildByType(AopElementTypes.AOP_OR);
        return or != null ? or : this.findChildByType(AopElementTypes.AOP_AND);
    }

    public String toString() {
        return "AopBinaryExpression";
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        Pair<AopPatternContainer, AopPatternContainer> pair = this.getOperands();
        if (pair == null) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (!(pair.first instanceof PsiPointcutExpression) || !(pair.second instanceof PsiPointcutExpression)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PsiPointcutExpression leftOperand = (PsiPointcutExpression)pair.first;
        PsiPointcutExpression rightOperand = (PsiPointcutExpression)pair.second;
        boolean and = this.getOperation() == AopOperation.AND;
        PointcutMatchDegree leftResult = leftOperand.acceptsSubject(context, member);
        if (and && leftResult == PointcutMatchDegree.FALSE) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (!and && leftResult == PointcutMatchDegree.TRUE) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree rightResult = rightOperand.acceptsSubject(context, member);
        PointcutMatchDegree pointcutMatchDegree = and ? PointcutMatchDegree.and(leftResult, rightResult) : PointcutMatchDegree.or(leftResult, rightResult);
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "acceptsSubject"));
        }
        return pointcutMatchDegree;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        Pair<AopPatternContainer, AopPatternContainer> pair = this.getOperands();
        if (pair == null) {
            List<AopPsiTypePattern> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "getPatterns"));
            }
            return list;
        }
        Collection<AopPsiTypePattern> leftPatterns = ((AopPatternContainer)pair.first).getPatterns();
        Collection<AopPsiTypePattern> rightPatterns = ((AopPatternContainer)pair.second).getPatterns();
        THashSet result = new THashSet();
        if (this.getOperation() == AopOperation.AND) {
            AopBinaryExpression.conjunctPatterns(leftPatterns, rightPatterns, (Collection<AopPsiTypePattern>)result);
        } else {
            result.addAll(leftPatterns);
            result.addAll(rightPatterns);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopBinaryExpression", "getPatterns"));
        }
        return tHashSet;
    }

    @Override
    public String getTypePattern() {
        AopTypeExpression[] expressions = (AopTypeExpression[])this.findChildrenByClass(AopTypeExpression.class);
        if (expressions.length != 2) {
            return null;
        }
        String pattern0 = expressions[0].getTypePattern();
        String pattern1 = expressions[1].getTypePattern();
        if (pattern0 == null || pattern1 == null) {
            return null;
        }
        Pair<AopPatternContainer, AopPatternContainer> pair = this.getOperands();
        if (pair == null) {
            return null;
        }
        return "'_:[is(\"" + pattern0 + "\") " + (this.getOperation() == AopOperation.AND ? "&&" : "||") + " is(\"" + pattern1 + "\")]";
    }

    public static void conjunctPatterns(Collection<AopPsiTypePattern> leftPatterns, Collection<AopPsiTypePattern> rightPatterns, Collection<AopPsiTypePattern> result) {
        for (AopPsiTypePattern leftPattern : leftPatterns) {
            for (AopPsiTypePattern rightPattern : rightPatterns) {
                result.add(AopPsiTypePatternsUtil.conjunctPatterns(leftPattern, rightPattern));
            }
        }
    }

    public static enum AopOperation {
        AND,
        OR;

    }
}

