/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopAnnotationHolder;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopParameterList
extends AopElementBase {
    static final TokenSet LIST_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{AopElementTypes.AOP_DOT_DOT, AopElementTypes.AOP_REFERENCE_HOLDER});

    public AopParameterList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopParameterList", "<init>"));
        }
        super(node);
    }

    public final PsiElement[] getParameters() {
        return this.findChildrenByType(LIST_ELEMENT_TYPES, PsiElement.class);
    }

    public String toString() {
        return "AopParameterList";
    }

    public PointcutMatchDegree matches(PointcutContext context, PsiParameterList list, TypeArgumentMatcher matcher) {
        return AopParameterList._match(context, matcher, list.getParameters(), 0, this.getParameters(), 0);
    }

    private static PointcutMatchDegree _match(PointcutContext context, TypeArgumentMatcher matcher, PsiParameter[] parameters, int javaIndex, PsiElement[] patterns, int aopIndex) {
        if (aopIndex >= patterns.length) {
            return PointcutMatchDegree.valueOf(javaIndex >= parameters.length);
        }
        PsiElement psiElement = patterns[aopIndex];
        if (psiElement instanceof AopReferenceHolder) {
            AopReferenceHolder pattern = (AopReferenceHolder)psiElement;
            if (javaIndex >= parameters.length) {
                return PointcutMatchDegree.FALSE;
            }
            PsiParameter parameter = parameters[javaIndex];
            AopAnnotationHolder prev = AopParameterList.findAnnotationPattern(pattern);
            if (prev != null && !prev.accepts((PsiModifierListOwner)parameter)) {
                return PointcutMatchDegree.FALSE;
            }
            PointcutMatchDegree first = matcher.matches(parameter, context.resolve(pattern));
            if (first == PointcutMatchDegree.FALSE) {
                return PointcutMatchDegree.FALSE;
            }
            return PointcutMatchDegree.and(first, AopParameterList._match(context, matcher, parameters, javaIndex + 1, patterns, aopIndex + 1));
        }
        if (aopIndex == patterns.length - 1) {
            return PointcutMatchDegree.TRUE;
        }
        PointcutMatchDegree result = PointcutMatchDegree.FALSE;
        for (int i = javaIndex; i < parameters.length; ++i) {
            if ((result = PointcutMatchDegree.or(result, AopParameterList._match(context, matcher, parameters, i, patterns, aopIndex + 1))) != PointcutMatchDegree.TRUE) continue;
            return PointcutMatchDegree.TRUE;
        }
        return result;
    }

    @Nullable
    private static AopAnnotationHolder findAnnotationPattern(AopReferenceHolder pattern) {
        PsiElement prev;
        for (prev = pattern.getPrevSibling(); prev != null && prev instanceof PsiWhiteSpace; prev = prev.getPrevSibling()) {
        }
        if (prev != null && prev.getNode().getElementType() == AopElementTypes.AOP_LEFT_PAR) {
            prev = prev.getPrevSibling();
        }
        while (prev != null && prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        return prev instanceof AopAnnotationHolder ? (AopAnnotationHolder)prev : null;
    }

    public static interface TypeArgumentMatcher {
        public PointcutMatchDegree matches(PsiParameter var1, AopReferenceTarget var2);
    }
}

