/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopBundle;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPointcutTypes;
import com.intellij.aop.psi.AopPrattRegistry;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PathPattern;
import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.lang.pratt.PrattParser;
import com.intellij.lang.pratt.PrattRegistry;
import com.intellij.lang.pratt.ReducingParser;
import com.intellij.lang.pratt.TokenParser;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.IElementTypePattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class AopPrattParser
extends PrattParser {
    static final int LOGIC = 30;
    static final int POINTCUT = 40;
    static final int TYPE_PATTERN = 70;
    static final int SIMPLE_TYPE = 90;
    static final int ATOM = 100;
    private static final IElementTypePattern REFERENCE_QUALIFIER = (IElementTypePattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{AopElementTypes.AOP_REFERENCE_EXPRESSION, AopElementTypes.AOP_PARENTHESIZED_EXPRESSION, AopElementTypes.AOP_SUBTYPE_EXPRESSION, AopElementTypes.AOP_ARRAY_EXPRESSION, AopElementTypes.AOP_GENERIC_TYPE_EXPRESSION});
    private static final ElementPattern<IElementType> ARRAYABLE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{REFERENCE_QUALIFIER, PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{AopElementTypes.AOP_PRIMITIVE_TYPE_EXPRESSION})});
    private static final ElementPattern<IElementType> ANY_TYPE_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{ARRAYABLE, PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{AopElementTypes.AOP_BINARY_EXPRESSION, AopElementTypes.AOP_NOT_EXPRESSION, AopElementTypes.AOP_PARENTHESIZED_EXPRESSION})});

    static boolean parseAnnotations(PrattBuilder builder) {
        MutableMarker annoHolder = builder.mark();
        boolean first = true;
        while (true) {
            if (builder.isToken((IElementType)AopElementTypes.AOP_NOT)) {
                MutableMarker not = builder.mark();
                builder.advance();
                if (!builder.isToken((IElementType)AopElementTypes.AOP_AT)) {
                    not.rollback();
                    annoHolder.drop();
                    return !first;
                }
                AopPrattParser.parseSingleAnnotation(builder);
                not.finish((IElementType)AopElementTypes.AOP_NOT_EXPRESSION);
            } else {
                if (!builder.isToken((IElementType)AopElementTypes.AOP_AT)) break;
                AopPrattParser.parseSingleAnnotation(builder);
            }
            first = false;
        }
        annoHolder.finish((IElementType)AopElementTypes.AOP_ANNOTATION_HOLDER);
        return true;
    }

    private static void parseSingleAnnotation(PrattBuilder builder) {
        MutableMarker anno = builder.mark();
        builder.advance();
        MutableMarker refHolder = builder.mark();
        builder.parseChildren(90, AopBundle.message("error.anno.expected", new Object[0]));
        refHolder.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
        AopPrattParser.parseAnnotationParameters(builder);
        anno.finish((IElementType)AopElementTypes.AOP_ANNOTATION_EXPRESSION);
    }

    private static void parseAnnotationParameters(PrattBuilder builder) {
        if (builder.getTokenType() == AopElementTypes.AOP_LEFT_PAR) {
            MutableMarker beforeLPar = builder.mark();
            builder.advance();
            if (builder.getTokenType() == AopElementTypes.AOP_ASTERISK || builder.getTokenType() == AopElementTypes.AOP_AT || builder.getTokenType() == AopElementTypes.AOP_NOT) {
                beforeLPar.rollback();
                return;
            }
            if (builder.getTokenType() == AopElementTypes.AOP_RIGHT_PAR) {
                beforeLPar.drop();
                builder.advance();
                return;
            }
            if (builder.getTokenType() == AopElementTypes.AOP_IDENTIFIER) {
                MutableMarker beforeId = builder.mark();
                builder.advance();
                if (builder.getTokenType() != AopElementTypes.BAD_CHARACTER || !"=".equals(builder.getTokenText())) {
                    beforeId.drop();
                    beforeLPar.rollback();
                    return;
                }
                beforeId.rollback();
            }
            beforeLPar.drop();
            MutableMarker params = builder.mark();
            int depth = 1;
            while (depth != 0 && !builder.isEof()) {
                builder.advance();
                if (builder.isToken((IElementType)AopElementTypes.AOP_LEFT_PAR)) {
                    ++depth;
                    continue;
                }
                if (builder.isToken((IElementType)AopElementTypes.AOP_LEFT_BRACE)) {
                    ++depth;
                    continue;
                }
                if (builder.isToken((IElementType)AopElementTypes.AOP_RIGHT_PAR)) {
                    --depth;
                    continue;
                }
                if (!builder.isToken((IElementType)AopElementTypes.AOP_RIGHT_BRACE)) continue;
                --depth;
            }
            params.finish((IElementType)AopElementTypes.AOP_ANNOTATION_VALUES);
            builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
        }
    }

    static void parsePointcut(PrattBuilder builder, PrattBuilder child) {
        MutableMarker marker = builder.mark();
        if (child.expecting(AopBundle.message("error.pointcut.expression.expected", new Object[0])).parse() == AopElementTypes.AOP_REFERENCE_EXPRESSION) {
            builder.error(AopBundle.message("error.0.expected", "("));
            marker.finish((IElementType)AopElementTypes.AOP_POINTCUT_REFERENCE);
            return;
        }
        marker.drop();
    }

    private static boolean noGapAdvance(PrattBuilder builder) {
        int offset = builder.getCurrentOffset();
        String s = builder.getTokenText();
        if (s == null) {
            return false;
        }
        int tokenLength = s.length();
        builder.advance();
        return builder.getCurrentOffset() == offset + tokenLength;
    }

    public static IElementType parsePatternPart(PrattBuilder builder) {
        boolean expectAsterisk;
        boolean bl = expectAsterisk = builder.getTokenType() == AopElementTypes.AOP_IDENTIFIER;
        while (AopPrattParser.noGapAdvance(builder) && (!expectAsterisk || builder.isToken((IElementType)AopElementTypes.AOP_ASTERISK) && AopPrattParser.noGapAdvance(builder))) {
            expectAsterisk = true;
            if (builder.isToken((IElementType)AopElementTypes.AOP_IDENTIFIER)) continue;
            break;
        }
        return AopElementTypes.AOP_REFERENCE_EXPRESSION;
    }

    protected PrattRegistry getRegistry() {
        return AopPrattRegistry.REGISTRY;
    }

    protected void parse(PrattBuilder builder) {
        AopPrattParser.parsePointcut(builder, builder);
        while (!builder.isEof()) {
            builder.advance();
        }
    }

    static {
        AopPointcutTypes.getPointcutTokens();
        AopPrattRegistry.registerParser(AopElementTypes.AOP_IDENTIFIER, 40, PathPattern.path().up(), TokenParser.postfix((IElementType)AopElementTypes.AOP_REFERENCE_EXPRESSION));
        AopPrattRegistry.registerParser(AopElementTypes.AOP_DOT, 40, PathPattern.path().left((IElementType)AopElementTypes.AOP_REFERENCE_EXPRESSION).up(), (TokenParser)new ReducingParser(){

            public IElementType parseFurther(PrattBuilder builder) {
                builder.assertToken((IElementType)AopElementTypes.AOP_IDENTIFIER, AopBundle.message("error.id.expected", new Object[0]));
                return AopElementTypes.AOP_REFERENCE_EXPRESSION;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_LEFT_PAR, 40, PathPattern.path().left((IElementType)AopElementTypes.AOP_REFERENCE_EXPRESSION).up(), (TokenParser)new ReducingParser(){

            public IElementType parseFurther(PrattBuilder builder) {
                MutableMarker paramList = builder.mark();
                if (!builder.isToken((IElementType)AopElementTypes.AOP_RIGHT_PAR)) {
                    do {
                        MutableMarker refHolder = builder.mark();
                        builder.parseChildren(90, AopBundle.message("error.pointcut.arguments.expected", new Object[0]));
                        refHolder.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
                    } while (builder.checkToken((IElementType)AopElementTypes.AOP_COMMA));
                }
                paramList.finish((IElementType)AopElementTypes.AOP_PARAMETER_LIST);
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                return AopElementTypes.AOP_POINTCUT_REFERENCE;
            }
        });
        for (IElementType type : AopElementTypes.AOP_PRIMITIVE_TYPES.getTypes()) {
            AopPrattRegistry.registerParser(type, 101, PathPattern.path().up(), TokenParser.postfix((IElementType)AopElementTypes.AOP_PRIMITIVE_TYPE_EXPRESSION));
        }
        AopPrattRegistry.registerParser(AopElementTypes.AOP_IDENTIFIER, 101, PathPattern.path().up(), new TokenParser(){

            public final boolean parseToken(PrattBuilder builder) {
                builder.reduce(AopPrattParser.parsePatternPart(builder));
                return true;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_ASTERISK, 101, PathPattern.path().up(), new TokenParser(){

            public final boolean parseToken(PrattBuilder builder) {
                builder.reduce(AopPrattParser.parsePatternPart(builder));
                return true;
            }
        });
        TokenParser pathSeparator = new TokenParser(){

            public final boolean parseToken(PrattBuilder builder) {
                builder.advance();
                if (builder.isToken((IElementType)AopElementTypes.AOP_NEW)) {
                    builder.advance();
                    builder.reduce((IElementType)AopElementTypes.AOP_CONSTRUCTOR_REFERENCE_EXPRESSION);
                    return false;
                }
                if (!builder.isToken((IElementType)AopElementTypes.AOP_ASTERISK) && !builder.isToken((IElementType)AopElementTypes.AOP_IDENTIFIER)) {
                    builder.error(AopBundle.message("error.id.expected", new Object[0]));
                    return true;
                }
                builder.reduce(AopPrattParser.parsePatternPart(builder));
                return true;
            }
        };
        AopPrattRegistry.registerParser(AopElementTypes.AOP_DOT, 91, PathPattern.path().left((ElementPattern)REFERENCE_QUALIFIER).up(), pathSeparator);
        AopPrattRegistry.registerParser(AopElementTypes.AOP_DOT_DOT, 89, PathPattern.path().left((ElementPattern)REFERENCE_QUALIFIER).up(), pathSeparator);
        AopPrattRegistry.registerParser(AopElementTypes.ANNO_WHITE_SPACE, Integer.MAX_VALUE, new TokenParser(){

            public boolean parseToken(PrattBuilder builder) {
                builder.advance();
                return false;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_OR, 31, PathPattern.path().left().up(), (TokenParser)new ReducingParser(){

            @Nullable
            public IElementType parseFurther(PrattBuilder builder) {
                AopPrattParser.parsePointcut(builder, builder.createChildBuilder(31));
                return AopElementTypes.AOP_POINTCUT_BINARY_EXPRESSION;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_AND, 32, PathPattern.path().left().up(), (TokenParser)new ReducingParser(){

            @Nullable
            public IElementType parseFurther(PrattBuilder builder) {
                AopPrattParser.parsePointcut(builder, builder.createChildBuilder(32));
                return AopElementTypes.AOP_POINTCUT_BINARY_EXPRESSION;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_NOT, 33, PathPattern.path().up(), (TokenParser)new ReducingParser(){

            @Nullable
            public IElementType parseFurther(PrattBuilder builder) {
                AopPrattParser.parsePointcut(builder, builder.createChildBuilder(32));
                return AopElementTypes.AOP_POINTCUT_NOT_EXPRESSION;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_OR, 71, PathPattern.path().left(ANY_TYPE_PATTERN).up(), TokenParser.infix((int)71, (IElementType)AopElementTypes.AOP_BINARY_EXPRESSION));
        AopPrattRegistry.registerParser(AopElementTypes.AOP_AND, 72, PathPattern.path().left(ANY_TYPE_PATTERN).up(), TokenParser.infix((int)72, (IElementType)AopElementTypes.AOP_BINARY_EXPRESSION));
        AopPrattRegistry.registerParser(AopElementTypes.AOP_NOT, 73, PathPattern.path().up(), new TokenParser(){

            public boolean parseToken(PrattBuilder builder) {
                MutableMarker annotatedType = builder.mark();
                MutableMarker not = builder.mark();
                builder.advance();
                if (builder.isToken((IElementType)AopElementTypes.AOP_AT)) {
                    not.rollback();
                    AopPrattParser.parseAnnotations(builder);
                    builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                    annotatedType.finish((IElementType)AopElementTypes.AOP_ANNOTATED_TYPE_EXPRESSION);
                    return true;
                }
                annotatedType.drop();
                builder.parseChildren(72, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                not.finish((IElementType)AopElementTypes.AOP_NOT_EXPRESSION);
                return true;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_AT, 75, PathPattern.path().up(), new TokenParser(){

            public boolean parseToken(PrattBuilder builder) {
                MutableMarker annotatedType = builder.mark();
                AopPrattParser.parseAnnotations(builder);
                builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                annotatedType.finish((IElementType)AopElementTypes.AOP_ANNOTATED_TYPE_EXPRESSION);
                return true;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_LEFT_PAR, 41, PathPattern.path().up(), (TokenParser)new ReducingParser(){

            public IElementType parseFurther(PrattBuilder builder) {
                AopPrattParser.parsePointcut(builder, builder.createChildBuilder(0));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                return AopElementTypes.AOP_POINTCUT_PARENTHESIZED_EXPRESSION;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_LEFT_PAR, 101, PathPattern.path().up(), (TokenParser)new ReducingParser(){

            public IElementType parseFurther(PrattBuilder builder) {
                builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                return AopElementTypes.AOP_PARENTHESIZED_EXPRESSION;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_LT, 81, PathPattern.path().left((ElementPattern)REFERENCE_QUALIFIER).up(), new TokenParser(){

            public boolean parseToken(PrattBuilder builder) {
                MutableMarker typeParamList = builder.mark();
                builder.advance();
                do {
                    MutableMarker holder = builder.mark();
                    MutableMarker wildcard = builder.mark();
                    if (builder.checkToken((IElementType)AopElementTypes.AOP_QUESTION)) {
                        if (builder.checkToken((IElementType)AopElementTypes.AOP_EXTENDS) || builder.checkToken((IElementType)AopElementTypes.AOP_SUPER)) {
                            builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                        }
                        wildcard.finish((IElementType)AopElementTypes.AOP_WILDCARD_EXPRESSION);
                    } else {
                        builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                        wildcard.drop();
                    }
                    holder.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
                } while (builder.checkToken((IElementType)AopElementTypes.AOP_COMMA));
                builder.assertToken((IElementType)AopElementTypes.AOP_GT, AopBundle.message("error.0.expected", ">"));
                typeParamList.finish((IElementType)AopElementTypes.AOP_TYPE_PARAMETER_LIST);
                builder.reduce((IElementType)AopElementTypes.AOP_GENERIC_TYPE_EXPRESSION);
                return true;
            }
        });
        AopPrattRegistry.registerParser(AopElementTypes.AOP_PLUS, 80, PathPattern.path().left((ElementPattern)REFERENCE_QUALIFIER).up(), TokenParser.postfix((IElementType)AopElementTypes.AOP_SUBTYPE_EXPRESSION));
        AopPrattRegistry.registerParser(AopElementTypes.AOP_BRACES, 79, PathPattern.path().left(ARRAYABLE).up(), TokenParser.postfix((IElementType)AopElementTypes.AOP_ARRAY_EXPRESSION));
        AopPrattRegistry.registerParser(AopElementTypes.AOP_BRACES, 79, PathPattern.path().left(ARRAYABLE).up(), TokenParser.postfix((IElementType)AopElementTypes.AOP_ARRAY_EXPRESSION));
        AopPrattRegistry.registerParser(AopElementTypes.AOP_VARARGS, 79, PathPattern.path().left(ARRAYABLE).up(), TokenParser.postfix((IElementType)AopElementTypes.AOP_ARRAY_EXPRESSION));
    }
}

