/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PackageAnnotator {
    private static final Logger LOG = Logger.getInstance((String)("#" + PackageAnnotator.class.getName()));
    private static final String DEFAULT_CONSTRUCTOR_NAME_SIGNATURE = "<init>()V";
    private final PsiPackage myPackage;
    private final Project myProject;
    private final PsiManager myManager;
    private final CoverageDataManager myCoverageManager;

    public PackageAnnotator(PsiPackage aPackage) {
        this.myPackage = aPackage;
        this.myProject = this.myPackage.getProject();
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myCoverageManager = CoverageDataManager.getInstance(this.myProject);
    }

    public void annotate(CoverageSuitesBundle suite, Annotator annotator) {
        PackageCoverageInfo info;
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        String qualifiedName = this.myPackage.getQualifiedName();
        boolean filtered = false;
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            if (!((JavaCoverageSuite)coverageSuite).isPackageFiltered(qualifiedName)) continue;
            filtered = true;
            break;
        }
        if (!filtered) {
            return;
        }
        GlobalSearchScope scope = suite.getSearchScope(this.myProject);
        Module[] modules = (Module[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> ModuleManager.getInstance((Project)this.myProject).getModules());
        if (modules == null) {
            return;
        }
        HashMap packageCoverageMap = new HashMap();
        HashMap flattenPackageCoverageMap = new HashMap();
        for (Module module : modules) {
            File outputRoot;
            VirtualFile testPackageRoot;
            File outputRoot2;
            if (!scope.isSearchInModuleContent(module)) continue;
            String rootPackageVMName = qualifiedName.replaceAll("\\.", "/");
            VirtualFile output = (VirtualFile)this.myCoverageManager.doInReadActionIfProjectOpen(() -> CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath());
            if (output != null && (outputRoot2 = PackageAnnotator.findRelativeFile(rootPackageVMName, output)).exists()) {
                this.collectCoverageInformation(outputRoot2, (Map<String, PackageCoverageInfo>)packageCoverageMap, (Map<String, PackageCoverageInfo>)flattenPackageCoverageMap, data, rootPackageVMName, annotator, module, suite.isTrackTestFolders(), false);
            }
            if (!suite.isTrackTestFolders() || (testPackageRoot = (VirtualFile)this.myCoverageManager.doInReadActionIfProjectOpen(() -> CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests())) == null || !(outputRoot = PackageAnnotator.findRelativeFile(rootPackageVMName, testPackageRoot)).exists()) continue;
            this.collectCoverageInformation(outputRoot, (Map<String, PackageCoverageInfo>)packageCoverageMap, (Map<String, PackageCoverageInfo>)flattenPackageCoverageMap, data, rootPackageVMName, annotator, module, suite.isTrackTestFolders(), true);
        }
        for (Map.Entry entry : packageCoverageMap.entrySet()) {
            String packageFQName = ((String)entry.getKey()).replaceAll("/", ".");
            info = (PackageCoverageInfo)entry.getValue();
            annotator.annotatePackage(packageFQName, info);
        }
        for (Map.Entry entry : flattenPackageCoverageMap.entrySet()) {
            String packageFQName = ((String)entry.getKey()).replaceAll("/", ".");
            info = (PackageCoverageInfo)entry.getValue();
            annotator.annotatePackage(packageFQName, info, true);
        }
    }

    private static File findRelativeFile(String rootPackageVMName, VirtualFile output) {
        File outputRoot = VfsUtilCore.virtualToIoFile((VirtualFile)output);
        outputRoot = rootPackageVMName.length() > 0 ? new File(outputRoot, FileUtil.toSystemDependentName((String)rootPackageVMName)) : outputRoot;
        return outputRoot;
    }

    public void annotateFilteredClass(PsiClass psiClass, CoverageSuitesBundle bundle, Annotator annotator) {
        ProjectData data = bundle.getCoverageData();
        if (data == null) {
            return;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            VirtualFile outputPath;
            boolean isInTests = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isInTestSourceContent(psiClass.getContainingFile().getVirtualFile());
            CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)module);
            VirtualFile virtualFile = outputPath = isInTests ? moduleExtension.getCompilerOutputPathForTests() : moduleExtension.getCompilerOutputPath();
            if (outputPath != null) {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    return;
                }
                String packageVMName = StringUtil.getPackageName((String)qualifiedName).replace('.', '/');
                File packageRoot = PackageAnnotator.findRelativeFile(packageVMName, outputPath);
                if (packageRoot != null && packageRoot.exists()) {
                    HashMap toplevelClassCoverage = new HashMap();
                    File[] files = packageRoot.listFiles();
                    if (files != null) {
                        for (File child : files) {
                            if (!PackageAnnotator.isClassFile(child)) continue;
                            String childName = PackageAnnotator.getClassName(child);
                            String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                            String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName(classFqVMName);
                            if (!toplevelClassSrcFQName.equals(qualifiedName)) continue;
                            this.collectClassCoverageInformation(child, psiClass, new PackageCoverageInfo(), data, (Map<String, ClassCoverageInfo>)toplevelClassCoverage, classFqVMName.replace("/", "."), toplevelClassSrcFQName);
                        }
                    }
                    for (ClassCoverageInfo coverageInfo : toplevelClassCoverage.values()) {
                        annotator.annotateClass(qualifiedName, coverageInfo);
                    }
                }
            }
        }
    }

    @Nullable
    private DirCoverageInfo[] collectCoverageInformation(File packageOutputRoot, Map<String, PackageCoverageInfo> packageCoverageMap, Map<String, PackageCoverageInfo> flattenPackageCoverageMap, ProjectData projectInfo, String packageVMName, Annotator annotator, Module module, boolean trackTestFolders, boolean isTestHierarchy) {
        ClassCoverageInfo coverageInfo;
        ContentEntry[] contentEntries;
        ArrayList<DirCoverageInfo> dirs = new ArrayList<DirCoverageInfo>();
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : contentEntry.getSourceFolders((JpsModuleSourceRootType)(isTestHierarchy ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE))) {
                VirtualFile file = folder.getFile();
                if (file == null) continue;
                String prefix = folder.getPackagePrefix().replaceAll("\\.", "/");
                VirtualFile relativeSrcRoot = file.findFileByRelativePath(StringUtil.trimStart((String)packageVMName, (String)prefix));
                dirs.add(new DirCoverageInfo(relativeSrcRoot));
            }
        }
        PackageCoverageInfo classWithoutSourceCoverageInfo = new PackageCoverageInfo();
        File[] children = packageOutputRoot.listFiles();
        if (children == null) {
            return null;
        }
        HashMap toplevelClassCoverage = new HashMap();
        for (File child : children) {
            String childName;
            if (child.isDirectory()) {
                childName = child.getName();
                String childPackageVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                DirCoverageInfo[] childCoverageInfo = this.collectCoverageInformation(child, packageCoverageMap, flattenPackageCoverageMap, projectInfo, childPackageVMName, annotator, module, trackTestFolders, isTestHierarchy);
                if (childCoverageInfo == null) continue;
                for (int i = 0; i < childCoverageInfo.length; ++i) {
                    DirCoverageInfo coverageInfo2 = childCoverageInfo[i];
                    DirCoverageInfo parentDir = (DirCoverageInfo)dirs.get(i);
                    parentDir.totalClassCount += coverageInfo2.totalClassCount;
                    parentDir.coveredClassCount += coverageInfo2.coveredClassCount;
                    parentDir.totalLineCount += coverageInfo2.totalLineCount;
                    parentDir.coveredLineCount += coverageInfo2.coveredLineCount;
                    parentDir.totalMethodCount += coverageInfo2.totalMethodCount;
                    parentDir.coveredMethodCount += coverageInfo2.coveredMethodCount;
                }
                continue;
            }
            if (!PackageAnnotator.isClassFile(child)) continue;
            childName = PackageAnnotator.getClassName(child);
            String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
            String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName(classFqVMName);
            Ref containingFileRef = new Ref();
            Ref psiClassRef = new Ref();
            CoverageSuitesBundle suitesBundle = this.myCoverageManager.getCurrentSuitesBundle();
            if (suitesBundle == null) continue;
            Boolean isInSource = (Boolean)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
                if (this.myProject.isDisposed()) {
                    return null;
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(toplevelClassSrcFQName, GlobalSearchScope.moduleScope((Module)module));
                if (aClass == null || !aClass.isValid()) {
                    return Boolean.FALSE;
                }
                psiClassRef.set((Object)aClass);
                containingFileRef.set((Object)aClass.getNavigationElement().getContainingFile().getVirtualFile());
                if (containingFileRef.isNull()) {
                    LOG.info("No virtual file found for: " + aClass);
                    return null;
                }
                ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                return fileIndex.isUnderSourceRootOfType((VirtualFile)containingFileRef.get(), JavaModuleSourceRootTypes.SOURCES) && (trackTestFolders || !fileIndex.isInTestSourceContent((VirtualFile)containingFileRef.get()));
            });
            PackageCoverageInfo coverageInfoForClass = null;
            String classCoverageKey = classFqVMName.replace('/', '.');
            boolean ignoreClass = false;
            boolean keepWithoutSource = false;
            for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
                if (extension.ignoreCoverageForClass(suitesBundle, child)) {
                    ignoreClass = true;
                    break;
                }
                if (!extension.keepCoverageInfoForClassWithoutSource(suitesBundle, child)) continue;
                keepWithoutSource = true;
            }
            if (ignoreClass) continue;
            if (isInSource != null && isInSource.booleanValue()) {
                for (DirCoverageInfo dirCoverageInfo : dirs) {
                    if (dirCoverageInfo.sourceRoot == null || !VfsUtil.isAncestor((VirtualFile)dirCoverageInfo.sourceRoot, (VirtualFile)((VirtualFile)containingFileRef.get()), (boolean)false)) continue;
                    coverageInfoForClass = dirCoverageInfo;
                    classCoverageKey = toplevelClassSrcFQName;
                    break;
                }
            }
            if (coverageInfoForClass == null && keepWithoutSource) {
                coverageInfoForClass = classWithoutSourceCoverageInfo;
            }
            if (coverageInfoForClass == null) continue;
            this.collectClassCoverageInformation(child, (PsiClass)psiClassRef.get(), coverageInfoForClass, projectInfo, (Map<String, ClassCoverageInfo>)toplevelClassCoverage, classFqVMName.replace("/", "."), classCoverageKey);
        }
        for (Map.Entry entry : toplevelClassCoverage.entrySet()) {
            String toplevelClassName = (String)entry.getKey();
            coverageInfo = (ClassCoverageInfo)entry.getValue();
            annotator.annotateClass(toplevelClassName, coverageInfo);
        }
        PackageCoverageInfo flattenPackageCoverageInfo = PackageAnnotator.getOrCreateCoverageInfo(flattenPackageCoverageMap, packageVMName);
        for (Map.Entry entry : toplevelClassCoverage.entrySet()) {
            coverageInfo = (ClassCoverageInfo)entry.getValue();
            flattenPackageCoverageInfo.append(coverageInfo);
        }
        PackageCoverageInfo packageCoverageInfo = PackageAnnotator.getOrCreateCoverageInfo(packageCoverageMap, packageVMName);
        for (DirCoverageInfo dir : dirs) {
            packageCoverageInfo.append(dir);
            if (isTestHierarchy) {
                annotator.annotateTestDirectory(dir.sourceRoot, dir, module);
                continue;
            }
            annotator.annotateSourceDirectory(dir.sourceRoot, dir, module);
        }
        packageCoverageInfo.append(classWithoutSourceCoverageInfo);
        return dirs.toArray(new DirCoverageInfo[dirs.size()]);
    }

    private static boolean isClassFile(File classFile) {
        return classFile.getName().endsWith(".class");
    }

    private static String getClassName(File classFile) {
        return StringUtil.trimEnd((String)classFile.getName(), (String)".class");
    }

    private static PackageCoverageInfo getOrCreateCoverageInfo(Map<String, PackageCoverageInfo> packageCoverageMap, String packageVMName) {
        PackageCoverageInfo coverageInfo = packageCoverageMap.get(packageVMName);
        if (coverageInfo == null) {
            coverageInfo = new PackageCoverageInfo();
            packageCoverageMap.put(packageVMName, coverageInfo);
        }
        return coverageInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void collectClassCoverageInformation(File classFile, @Nullable PsiClass psiClass, PackageCoverageInfo packageCoverageInfo, ProjectData projectInfo, Map<String, ClassCoverageInfo> toplevelClassCoverage, String className, String toplevelClassSrcFQName) {
        ClassCoverageInfo toplevelClassCoverageInfo = new ClassCoverageInfo();
        ClassData classData = projectInfo.getClassData(className);
        if (classData == null || classData.getLines() == null) {
            if (!this.collectNonCoveredClassInfo(classFile, psiClass, toplevelClassCoverageInfo, packageCoverageInfo)) {
                LOG.debug("Did not collect non-covered class info for " + classFile.getName());
                return;
            }
        } else {
            Object[] lines;
            for (Object l : lines = classData.getLines()) {
                if (!(l instanceof LineData)) continue;
                LineData lineData = (LineData)l;
                if (lineData.getStatus() == 2) {
                    ++toplevelClassCoverageInfo.fullyCoveredLineCount;
                } else if (lineData.getStatus() == 1) {
                    ++toplevelClassCoverageInfo.partiallyCoveredLineCount;
                }
                ++toplevelClassCoverageInfo.totalLineCount;
                ++packageCoverageInfo.totalLineCount;
            }
            boolean touchedClass = false;
            Collection methodSigs = classData.getMethodSigs();
            for (Object nameAndSig : methodSigs) {
                if (PackageAnnotator.isGeneratedDefaultConstructor(psiClass, (String)nameAndSig)) continue;
                int covered = classData.getStatus((String)nameAndSig);
                if (covered != 0) {
                    ++toplevelClassCoverageInfo.coveredMethodCount;
                    touchedClass = true;
                }
                ++toplevelClassCoverageInfo.totalMethodCount;
            }
            if (methodSigs.isEmpty()) {
                LOG.debug("Did not find any method signatures in " + classFile.getName());
                return;
            }
            if (touchedClass) {
                ++packageCoverageInfo.coveredClassCount;
            }
            ++packageCoverageInfo.totalClassCount;
            packageCoverageInfo.coveredLineCount += toplevelClassCoverageInfo.fullyCoveredLineCount;
            packageCoverageInfo.coveredLineCount += toplevelClassCoverageInfo.partiallyCoveredLineCount;
            packageCoverageInfo.coveredMethodCount += toplevelClassCoverageInfo.coveredMethodCount;
            packageCoverageInfo.totalMethodCount += toplevelClassCoverageInfo.totalMethodCount;
        }
        ClassCoverageInfo classCoverageInfo = PackageAnnotator.getOrCreateClassCoverageInfo(toplevelClassCoverage, toplevelClassSrcFQName);
        LOG.debug("Adding coverage of " + classFile.getName() + " to top-level class " + toplevelClassSrcFQName);
        classCoverageInfo.totalLineCount += toplevelClassCoverageInfo.totalLineCount;
        classCoverageInfo.fullyCoveredLineCount += toplevelClassCoverageInfo.fullyCoveredLineCount;
        classCoverageInfo.partiallyCoveredLineCount += toplevelClassCoverageInfo.partiallyCoveredLineCount;
        classCoverageInfo.totalMethodCount += toplevelClassCoverageInfo.totalMethodCount;
        classCoverageInfo.coveredMethodCount += toplevelClassCoverageInfo.coveredMethodCount;
        if (toplevelClassCoverageInfo.getCoveredLineCount() > 0) {
            ++classCoverageInfo.coveredClassCount;
        }
    }

    public static boolean isGeneratedDefaultConstructor(@Nullable PsiClass aClass, String nameAndSig) {
        if (DEFAULT_CONSTRUCTOR_NAME_SIGNATURE.equals(nameAndSig)) {
            return PackageAnnotator.hasGeneratedConstructor(aClass);
        }
        return false;
    }

    private static boolean hasGeneratedConstructor(final @Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return aClass.getConstructors().length == 0;
            }
        });
    }

    private static ClassCoverageInfo getOrCreateClassCoverageInfo(Map<String, ClassCoverageInfo> toplevelClassCoverage, String sourceToplevelFQName) {
        ClassCoverageInfo toplevelClassCoverageInfo = toplevelClassCoverage.get(sourceToplevelFQName);
        if (toplevelClassCoverageInfo == null) {
            toplevelClassCoverageInfo = new ClassCoverageInfo();
            toplevelClassCoverage.put(sourceToplevelFQName, toplevelClassCoverageInfo);
        } else {
            ++toplevelClassCoverageInfo.totalClassCount;
        }
        return toplevelClassCoverageInfo;
    }

    private static String getSourceToplevelFQName(String classFQVMName) {
        int index = classFQVMName.indexOf(36);
        if (index > 0) {
            classFQVMName = classFQVMName.substring(0, index);
        }
        classFQVMName = StringUtil.trimStart((String)classFQVMName, (String)"/");
        return classFQVMName.replaceAll("/", ".");
    }

    private boolean collectNonCoveredClassInfo(File classFile, @Nullable PsiClass psiClass, ClassCoverageInfo classCoverageInfo, PackageCoverageInfo packageCoverageInfo) {
        byte[] content = (byte[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> {
            try {
                return FileUtil.loadFileBytes((File)classFile);
            }
            catch (IOException e) {
                return null;
            }
        });
        CoverageSuitesBundle coverageSuite = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (coverageSuite == null) {
            return false;
        }
        return SourceLineCounterUtil.collectNonCoveredClassInfo(classCoverageInfo, packageCoverageInfo, content, coverageSuite.isTracingEnabled(), psiClass);
    }

    public static class DirCoverageInfo
    extends PackageCoverageInfo {
        public VirtualFile sourceRoot;

        public DirCoverageInfo(VirtualFile sourceRoot) {
            this.sourceRoot = sourceRoot;
        }
    }

    public static class PackageCoverageInfo
    extends SummaryCoverageInfo {
        public int coveredLineCount;

        @Override
        public int getCoveredLineCount() {
            return this.coveredLineCount;
        }

        public void append(SummaryCoverageInfo info) {
            this.totalClassCount += info.totalClassCount;
            this.totalLineCount += info.totalLineCount;
            this.coveredClassCount += info.coveredClassCount;
            this.coveredLineCount += info.getCoveredLineCount();
            this.coveredMethodCount += info.coveredMethodCount;
            this.totalMethodCount += info.totalMethodCount;
        }
    }

    public static class ClassCoverageInfo
    extends SummaryCoverageInfo {
        public int fullyCoveredLineCount;
        public int partiallyCoveredLineCount;

        public ClassCoverageInfo() {
            this.totalClassCount = 1;
        }

        @Override
        public int getCoveredLineCount() {
            return this.fullyCoveredLineCount + this.partiallyCoveredLineCount;
        }
    }

    public static abstract class SummaryCoverageInfo {
        public int totalClassCount;
        public int coveredClassCount;
        public int totalMethodCount;
        public int coveredMethodCount;
        public int totalLineCount;

        public abstract int getCoveredLineCount();
    }

    public static interface Annotator {
        public void annotateSourceDirectory(VirtualFile var1, PackageCoverageInfo var2, Module var3);

        public void annotateTestDirectory(VirtualFile var1, PackageCoverageInfo var2, Module var3);

        public void annotatePackage(String var1, PackageCoverageInfo var2);

        public void annotatePackage(String var1, PackageCoverageInfo var2, boolean var3);

        public void annotateClass(String var1, ClassCoverageInfo var2);
    }
}

