/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.AbstractNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.internal.tasks.cache.TaskCacheKeyBuilder;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.hash.HashUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskFilePropertyPathSensitivity {
    ABSOLUTE{

        public NormalizedFileSnapshot getNormalizedSnapshot(FileTreeElement fileDetails, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
            String absolutePath = stringInterner.intern(fileDetails.getFile().getAbsolutePath());
            return new NonNormalizedFileSnapshot(absolutePath, snapshot);
        }
    }
    ,
    RELATIVE{

        public NormalizedFileSnapshot getNormalizedSnapshot(FileTreeElement fileDetails, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
            if (fileDetails instanceof SingletonFileTree.SingletonFileVisitDetails) {
                return new IgnoredPathFileSnapshot(snapshot);
            }
            String[] segments = fileDetails.getRelativePath().getSegments();
            StringBuilder builder = new StringBuilder();
            int len = segments.length;
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    builder.append('/');
                }
                builder.append(segments[i]);
            }
            return TaskFilePropertyPathSensitivity.getRelativeSnapshot(fileDetails, builder.toString(), snapshot, stringInterner);
        }
    }
    ,
    NAME_ONLY{

        public NormalizedFileSnapshot getNormalizedSnapshot(FileTreeElement fileDetails, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
            return TaskFilePropertyPathSensitivity.getRelativeSnapshot(fileDetails, fileDetails.getName(), snapshot, stringInterner);
        }
    }
    ,
    NONE{

        public NormalizedFileSnapshot getNormalizedSnapshot(FileTreeElement fileDetails, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
            if (fileDetails.isDirectory()) {
                return null;
            }
            return new IgnoredPathFileSnapshot(snapshot);
        }
    };

    private static final String EMPTY_STRING = "";

    public abstract NormalizedFileSnapshot getNormalizedSnapshot(FileTreeElement var1, IncrementalFileSnapshot var2, StringInterner var3);

    public static TaskFilePropertyPathSensitivity valueOf(PathSensitivity pathSensitivity) {
        switch (pathSensitivity) {
            case ABSOLUTE: {
                return ABSOLUTE;
            }
            case RELATIVE: {
                return RELATIVE;
            }
            case NAME_ONLY: {
                return NAME_ONLY;
            }
            case NONE: {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown path usage: " + (Object)((Object)pathSensitivity));
    }

    private static NormalizedFileSnapshot getRelativeSnapshot(FileTreeElement fileDetails, String normalizedPath, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
        String absolutePath = stringInterner.intern(fileDetails.getFile().getAbsolutePath());
        if (absolutePath.endsWith(normalizedPath)) {
            return new IndexedNormalizedFileSnapshot(absolutePath, absolutePath.length() - normalizedPath.length(), snapshot);
        }
        return new DefaultNormalizedFileSnapshot(stringInterner.intern(normalizedPath), snapshot);
    }

    public static class IgnoredPathFileSnapshot
    implements NormalizedFileSnapshot {
        private final IncrementalFileSnapshot snapshot;

        public IgnoredPathFileSnapshot(IncrementalFileSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getNormalizedPath() {
            return TaskFilePropertyPathSensitivity.EMPTY_STRING;
        }

        public IncrementalFileSnapshot getSnapshot() {
            return this.snapshot;
        }

        public void appendToCacheKey(TaskCacheKeyBuilder builder) {
            builder.putBytes(this.snapshot.getHash().asBytes());
        }

        public int compareTo(NormalizedFileSnapshot o) {
            if (!(o instanceof IgnoredPathFileSnapshot)) {
                return -1;
            }
            return HashUtil.compareHashCodes((HashCode)this.getSnapshot().getHash(), (HashCode)o.getSnapshot().getHash());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IgnoredPathFileSnapshot that = (IgnoredPathFileSnapshot)o;
            return Objects.equal((Object)this.snapshot, (Object)that.snapshot);
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }
    }

    public static class DefaultNormalizedFileSnapshot
    extends AbstractNormalizedFileSnapshot {
        private final String normalizedPath;

        public DefaultNormalizedFileSnapshot(String normalizedPath, IncrementalFileSnapshot snapshot) {
            super(snapshot);
            this.normalizedPath = normalizedPath;
        }

        public String getNormalizedPath() {
            return this.normalizedPath;
        }
    }

    public static class IndexedNormalizedFileSnapshot
    extends AbstractNormalizedFileSnapshot {
        private final String absolutePath;
        private final int index;

        public IndexedNormalizedFileSnapshot(String absolutePath, int index, IncrementalFileSnapshot snapshot) {
            super(snapshot);
            this.absolutePath = absolutePath;
            this.index = index;
        }

        public String getNormalizedPath() {
            return this.absolutePath.substring(this.index);
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class NonNormalizedFileSnapshot
    extends AbstractNormalizedFileSnapshot {
        private final String absolutePath;

        public NonNormalizedFileSnapshot(String absolutePath, IncrementalFileSnapshot snapshot) {
            super(snapshot);
            this.absolutePath = absolutePath;
        }

        public String getNormalizedPath() {
            return this.absolutePath;
        }
    }
}

