/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final Map<RelativePath, Action<OutputStream>> elements = new LinkedHashMap<RelativePath, Action<OutputStream>>();
    private final Factory<File> tmpDirSource;
    private final Chmod chmod;

    public MapFileTree(final File tmpDir, Chmod chmod) {
        this(new Factory<File>(){

            public File create() {
                return tmpDir;
            }
        }, chmod);
    }

    public MapFileTree(Factory<File> tmpDirSource, Chmod chmod) {
        this.tmpDirSource = tmpDirSource;
        this.chmod = chmod;
    }

    private File getTmpDir() {
        return (File)this.tmpDirSource.create();
    }

    @Override
    public String getDisplayName() {
        return "file tree";
    }

    @Override
    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.getTmpDir());
    }

    @Override
    public void visit(FileVisitor visitor) {
        AtomicBoolean stopFlag = new AtomicBoolean();
        Visit visit = new Visit(visitor, stopFlag);
        for (Map.Entry<RelativePath, Action<OutputStream>> entry : this.elements.entrySet()) {
            if (stopFlag.get()) break;
            RelativePath path = entry.getKey();
            Action<OutputStream> generator = entry.getValue();
            visit.visit(path, generator);
        }
    }

    public Set<File> getFilesWithoutCreating() {
        return CollectionUtils.collect(this.elements.keySet(), (Transformer)new Transformer<File, RelativePath>(){

            public File transform(RelativePath relativePath) {
                return MapFileTree.this.createFileInstance(relativePath);
            }
        });
    }

    public void add(String path, Closure contentClosure) {
        Action action = ConfigureUtil.configureUsing(contentClosure);
        this.add(path, action);
    }

    public void add(String path, Action<OutputStream> contentWriter) {
        this.elements.put(RelativePath.parse(true, path), contentWriter);
    }

    private File createFileInstance(RelativePath path) {
        return path.getFile(this.getTmpDir());
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final RelativePath path;
        private final Action<OutputStream> generator;
        private long lastModified;
        private long size;
        private final AtomicBoolean stopFlag;
        private File file;
        private final boolean isDirectory;

        public FileVisitDetailsImpl(RelativePath path, Action<OutputStream> generator, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.path = path;
            this.generator = generator;
            this.stopFlag = stopFlag;
            this.isDirectory = !path.isFile();
        }

        @Override
        public String getDisplayName() {
            return this.path.toString();
        }

        @Override
        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        @Override
        public File getFile() {
            if (this.file == null) {
                this.file = MapFileTree.this.createFileInstance(this.path);
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                } else if (!this.isDirectory()) {
                    this.updateFileOnlyWhenGeneratedContentChanges();
                }
                this.lastModified = this.file.lastModified() / 1000L * 1000L;
                this.size = this.file.length();
            }
            return this.file;
        }

        @Override
        public void copyTo(OutputStream output) {
            this.generator.execute((Object)output);
        }

        private void updateFileOnlyWhenGeneratedContentChanges() {
            byte[] generatedContent = this.generateContent();
            if (!this.hasContent(generatedContent, this.file)) {
                try {
                    Files.write((byte[])generatedContent, (File)this.file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        }

        private byte[] generateContent() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(Math.max((int)this.file.length() + 64, 256));
            this.copyTo(buffer);
            return buffer.toByteArray();
        }

        private boolean hasContent(byte[] generatedContent, File file) {
            byte[] existingContent;
            if ((long)generatedContent.length != file.length()) {
                return false;
            }
            try {
                existingContent = Files.toByteArray((File)this.file);
            }
            catch (IOException e) {
                return false;
            }
            return Arrays.equals(generatedContent, existingContent);
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public long getLastModified() {
            this.getFile();
            return this.lastModified;
        }

        @Override
        public long getSize() {
            this.getFile();
            return this.size;
        }

        @Override
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Visit {
        private final Set<RelativePath> visitedDirs = new LinkedHashSet<RelativePath>();
        private final FileVisitor visitor;
        private final AtomicBoolean stopFlag;

        public Visit(FileVisitor visitor, AtomicBoolean stopFlag) {
            this.visitor = visitor;
            this.stopFlag = stopFlag;
        }

        private void visitDirs(RelativePath path, FileVisitor visitor) {
            if (path == null || path.getParent() == null || !this.visitedDirs.add(path)) {
                return;
            }
            this.visitDirs(path.getParent(), visitor);
            visitor.visitDir(new FileVisitDetailsImpl(path, null, this.stopFlag, MapFileTree.this.chmod));
        }

        public void visit(RelativePath path, Action<OutputStream> generator) {
            this.visitDirs(path.getParent(), this.visitor);
            this.visitor.visitFile(new FileVisitDetailsImpl(path, generator, this.stopFlag, MapFileTree.this.chmod));
        }
    }
}

