/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputPropertyAnnotationUtil {
    OutputPropertyAnnotationUtil() {
    }

    public static void validateFile(String propertyName, File file, Collection<String> messages) {
        if (file.exists() && file.isDirectory()) {
            messages.add(String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", file, propertyName));
        }
        for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
            if (!candidate.exists() || candidate.isDirectory()) continue;
            messages.add(String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, propertyName, candidate));
            break;
        }
    }

    public static void validateDirectory(String propertyName, File directory, Collection<String> messages) {
        if (directory.exists() && !directory.isDirectory()) {
            messages.add(String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
            return;
        }
        for (File candidate = directory; candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
            if (!candidate.exists() || candidate.isDirectory()) continue;
            messages.add(String.format("Cannot write to directory '%s' specified for property '%s', as ancestor '%s' is not a directory.", directory, propertyName, candidate));
            return;
        }
    }
}

