/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Nullable;
import org.gradle.internal.classloader.TransformingClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.util.internal.Java9ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixInLegacyTypesClassLoader
extends TransformingClassLoader {
    private static final Type GROOVY_OBJECT_TYPE = Type.getType(GroovyObject.class);
    private static final Type META_CLASS_REGISTRY_TYPE = Type.getType(MetaClassRegistry.class);
    private static final Type GROOVY_SYSTEM_TYPE = Type.getType(GroovySystem.class);
    private static final Type META_CLASS_TYPE = Type.getType(MetaClass.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final String RETURN_OBJECT_FROM_OBJECT_STRING_OBJECT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{OBJECT_TYPE, STRING_TYPE, OBJECT_TYPE});
    private static final String RETURN_OBJECT_FROM_STRING_OBJECT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
    private static final String RETURN_OBJECT_FROM_STRING = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_OBJECT_FROM_OBJECT_STRING = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{OBJECT_TYPE, STRING_TYPE});
    private static final String RETURN_VOID_FROM_OBJECT_STRING_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE, STRING_TYPE, OBJECT_TYPE});
    private static final String RETURN_VOID_FROM_STRING_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
    private static final String RETURN_META_CLASS_REGISTRY = Type.getMethodDescriptor((Type)META_CLASS_REGISTRY_TYPE, (Type[])new Type[0]);
    private static final String RETURN_META_CLASS_FROM_CLASS = Type.getMethodDescriptor((Type)META_CLASS_TYPE, (Type[])new Type[]{CLASS_TYPE});
    private static final String RETURN_META_CLASS = Type.getMethodDescriptor((Type)META_CLASS_TYPE, (Type[])new Type[0]);
    private static final String RETURN_CLASS = Type.getMethodDescriptor((Type)CLASS_TYPE, (Type[])new Type[0]);
    private static final String META_CLASS_FIELD = "__meta_class__";
    private final Set<String> classesToMixInGroovyObject = this.readClassNames("converted-types.txt");
    private final Set<String> syntheticClasses = this.readClassNames("removed-types.txt");

    public MixInLegacyTypesClassLoader(ClassLoader parent, ClassPath classPath) {
        super(parent, classPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readClassNames(String resourceName) {
        HashSet<String> classNames = new HashSet<String>();
        URL resource = ((Object)((Object)this)).getClass().getResource(resourceName);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    classNames.add(line.trim());
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load class names from '" + resource + "'.", e);
        }
        return classNames;
    }

    @Nullable
    protected byte[] generateMissingClass(String name) {
        if (!this.syntheticClasses.contains(name)) {
            return null;
        }
        ClassWriter visitor = new ClassWriter(0);
        visitor.visit(51, 5633, name.replace('.', '/'), null, OBJECT_TYPE.getInternalName(), null);
        visitor.visitEnd();
        return visitor.toByteArray();
    }

    protected boolean shouldTransform(String className) {
        return this.classesToMixInGroovyObject.contains(className) || this.syntheticClasses.contains(className);
    }

    protected byte[] transform(String className, byte[] bytes) {
        Java9ClassReader classReader = new Java9ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        classReader.accept(new TransformingAdapter((ClassVisitor)classWriter), 0);
        bytes = classWriter.toByteArray();
        return bytes;
    }

    private static class TransformingAdapter
    extends ClassVisitor {
        private static final int PUBLIC_STATIC_FINAL = 25;
        private String className;
        private Map<String, String> missingStaticStringConstantGetters = new HashMap<String, String>();
        private Set<String> booleanGetGetters = new HashSet<String>();
        private Set<String> booleanFields = new HashSet<String>();
        private Set<String> booleanIsGetters = new HashSet<String>();

        TransformingAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            LinkedHashSet<String> interfaceNames = new LinkedHashSet<String>(Arrays.asList(interfaces));
            interfaceNames.add(GROOVY_OBJECT_TYPE.getInternalName());
            this.cv.visit(version, access, name, signature, superName, interfaceNames.toArray(new String[0]));
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 0x19) == 25 && Type.getDescriptor(String.class).equals(desc)) {
                this.missingStaticStringConstantGetters.put("get" + name, (String)value);
            }
            if ((access & 2) > 0 && !this.isStatic(access) && Type.getDescriptor(Boolean.TYPE).equals(desc)) {
                this.booleanFields.add(name);
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            PropertyAccessorType accessorType;
            if (this.missingStaticStringConstantGetters.containsKey(name)) {
                this.missingStaticStringConstantGetters.remove(name);
            }
            if ((access & 1) > 0 && !this.isStatic(access) && Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]).equals(desc) && (accessorType = PropertyAccessorType.fromName((String)name)) != null) {
                String propertyName = accessorType.propertyNameFor(name);
                if (accessorType == PropertyAccessorType.IS_GETTER) {
                    this.booleanIsGetters.add(propertyName);
                } else if (accessorType == PropertyAccessorType.GET_GETTER) {
                    this.booleanGetGetters.add(propertyName);
                }
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            this.addMetaClassField();
            this.addGetMetaClass();
            this.addSetMetaClass();
            this.addGetProperty();
            this.addSetProperty();
            this.addInvokeMethod();
            this.addStaticStringConstantGetters();
            this.addBooleanGetGetters();
            this.cv.visitEnd();
        }

        private boolean isStatic(int access) {
            return (access & 8) > 0;
        }

        private void addMetaClassField() {
            this.cv.visitField(2, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor(), null, null);
        }

        private void addGetProperty() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "getProperty", RETURN_OBJECT_FROM_STRING, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.className, "getMetaClass", RETURN_META_CLASS, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, META_CLASS_TYPE.getInternalName(), "getProperty", RETURN_OBJECT_FROM_OBJECT_STRING, true);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(3, 2);
            methodVisitor.visitEnd();
        }

        private void addSetProperty() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "setProperty", RETURN_VOID_FROM_STRING_OBJECT, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.className, "getMetaClass", RETURN_META_CLASS, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, META_CLASS_TYPE.getInternalName(), "setProperty", RETURN_VOID_FROM_OBJECT_STRING_OBJECT, true);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(4, 3);
            methodVisitor.visitEnd();
        }

        private void addInvokeMethod() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "invokeMethod", RETURN_OBJECT_FROM_STRING_OBJECT, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.className, "getMetaClass", RETURN_META_CLASS, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, META_CLASS_TYPE.getInternalName(), "invokeMethod", RETURN_OBJECT_FROM_OBJECT_STRING_OBJECT, true);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(4, 3);
            methodVisitor.visitEnd();
        }

        private void addGetMetaClass() {
            Label lookup = new Label();
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "getMetaClass", RETURN_META_CLASS, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitInsn(89);
            methodVisitor.visitJumpInsn(198, lookup);
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(lookup);
            methodVisitor.visitFrame(-1, 1, new Object[]{this.className}, 1, new Object[]{META_CLASS_TYPE.getInternalName()});
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, GROOVY_SYSTEM_TYPE.getInternalName(), "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "getClass", RETURN_CLASS, false);
            methodVisitor.visitMethodInsn(185, META_CLASS_REGISTRY_TYPE.getInternalName(), "getMetaClass", RETURN_META_CLASS_FROM_CLASS, true);
            methodVisitor.visitFieldInsn(181, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(4, 1);
            methodVisitor.visitEnd();
        }

        private void addSetMetaClass() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "setMetaClass", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{META_CLASS_TYPE}), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(2, 2);
            methodVisitor.visitEnd();
        }

        private void addStaticStringConstantGetters() {
            for (Map.Entry<String, String> constant : this.missingStaticStringConstantGetters.entrySet()) {
                MethodVisitor mv = this.cv.visitMethod(4105, constant.getKey(), Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), null, null);
                mv.visitCode();
                mv.visitLdcInsn((Object)constant.getValue());
                mv.visitInsn(176);
                mv.visitMaxs(1, 0);
                mv.visitEnd();
            }
        }

        private void addBooleanGetGetters() {
            HashSet<String> accessibleBooleanFieldsWithoutGetGetters = new HashSet<String>();
            accessibleBooleanFieldsWithoutGetGetters.addAll(this.booleanFields);
            accessibleBooleanFieldsWithoutGetGetters.retainAll(this.booleanIsGetters);
            accessibleBooleanFieldsWithoutGetGetters.removeAll(this.booleanGetGetters);
            for (String booleanField : accessibleBooleanFieldsWithoutGetGetters) {
                this.addBooleanGetGetter(booleanField);
            }
        }

        private void addBooleanGetGetter(String booleanField) {
            MethodVisitor mv = this.cv.visitMethod(4097, "get" + StringUtils.capitalize((String)booleanField), "()Z", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, booleanField, "Z");
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + this.className + ";", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }
}

