/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class NewAbstractDataHolder {
    private String myName;
    private String myClassName;
    private PsiDirectory myClassDirectory;
    protected final JavaeeCodeStyleSettings myCodeStyleSettings;
    protected final Module myModule;
    private final List<? extends Object> myExistings;
    private final String myOldName;

    protected NewAbstractDataHolder(@NotNull Module module, List<? extends Object> existings, String oldName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/NewAbstractDataHolder", "<init>"));
        }
        this.myModule = module;
        this.myExistings = existings;
        this.myOldName = oldName;
        this.myCodeStyleSettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)module.getProject()).getCustomSettings(JavaeeCodeStyleSettings.class);
    }

    public Module getModule() {
        return this.myModule;
    }

    @NonNls
    protected abstract String getDefaultName();

    protected abstract String getObjectName(Object var1);

    protected String getUniqueName() {
        String defaultName;
        Set existingNames = ContainerUtil.map2Set(this.myExistings, (Function)new Function<Object, String>(){

            public String fun(Object s) {
                return NewAbstractDataHolder.this.getObjectName(s);
            }
        });
        if (!existingNames.contains(this.getFullName(defaultName = this.getDefaultName()))) {
            return defaultName;
        }
        int i = 2;
        String name;
        while (existingNames.contains(this.getFullName(name = defaultName + i))) {
            ++i;
        }
        return name;
    }

    private String getFullName(String defaultName) {
        return this.getNamePrefix(this.myCodeStyleSettings) + defaultName + this.getNameSuffix(this.myCodeStyleSettings);
    }

    public abstract String getNamePrefix(JavaeeCodeStyleSettings var1);

    public abstract String getNameSuffix(JavaeeCodeStyleSettings var1);

    public String getName() {
        return this.myName;
    }

    public void setName(@NonNls String name) {
        this.myName = name;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(@NonNls String className) {
        this.myClassName = className;
    }

    public PsiDirectory getClassDirectory() {
        return this.myClassDirectory;
    }

    public void setClassDirectory(PsiDirectory classDirectory) {
        this.myClassDirectory = ClassUtil.sourceRoot((PsiDirectory)classDirectory);
    }

    public void setPackage(String packageName) {
        this.myClassName = ClassUtil.createNewClassQualifiedName((String)packageName, (String)this.myClassName);
    }

    public String getPackage() {
        return ClassUtil.extractPackageName((String)this.getClassName());
    }

    public String getPureName() {
        String result = this.getName();
        String namePrefix = this.getNamePrefix(this.myCodeStyleSettings);
        result = StringUtil.trimStart((String)result, (String)namePrefix);
        String nameSuffix = this.getNameSuffix(this.myCodeStyleSettings);
        result = StringUtil.trimEnd((String)result, (String)nameSuffix);
        return result;
    }

    public boolean checkNameIsUnique() {
        String name = this.getName();
        if (Comparing.equal((String)this.myOldName, (String)name)) {
            return true;
        }
        for (Object object : this.myExistings) {
            String anotherName = this.getObjectName(object);
            if (Comparing.equal((String)anotherName, (String)this.myOldName) || !Comparing.equal((String)anotherName, (String)name)) continue;
            return false;
        }
        return true;
    }
}

