/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServerIntegrations;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.context.DefaultWebModuleContextProvider;
import com.intellij.javaee.context.DeploymentModelContext;
import com.intellij.javaee.context.FacetContextProvider;
import com.intellij.javaee.context.JavaeeAppFacetContextProvider;
import com.intellij.javaee.context.WebModuleContextProvider;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerUrlMapping
implements AppServerDeployedFileUrlProvider {
    private static final JavaeeFacet DEFAULT_DEPLOYMENT_CONTEXT_KEY = null;
    private final Map<J2EEServerInstance, ServerInstanceMapping> myServerInstance2Mapping = new HashMap<J2EEServerInstance, ServerInstanceMapping>();
    private WebModuleContextProvider myCompositeWebModuleContextProvider;
    private List<FacetContextProvider> myFacetContextProvider;

    private WebModuleContextProvider getWebModuleContextProviders() {
        if (this.myCompositeWebModuleContextProvider == null) {
            final ArrayList<WebModuleContextProvider> webModuleContextProviders = new ArrayList<WebModuleContextProvider>();
            this.collectWebModuleContextProviders(webModuleContextProviders);
            this.myCompositeWebModuleContextProvider = new WebModuleContextProvider(){

                @Override
                @Nullable
                public String getContext(@NotNull JavaeeApplicationFacet earFacet, @Nullable String moduleWebUri) {
                    if (earFacet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earFacet", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping$1", "getContext"));
                    }
                    for (WebModuleContextProvider provider : webModuleContextProviders) {
                        String context = provider.getContext(earFacet, moduleWebUri);
                        if (context == null) continue;
                        return context;
                    }
                    return null;
                }
            };
        }
        return this.myCompositeWebModuleContextProvider;
    }

    protected void collectWebModuleContextProviders(List<WebModuleContextProvider> webModuleContextProvider) {
        webModuleContextProvider.add(DefaultWebModuleContextProvider.INSTANCE);
    }

    private List<FacetContextProvider> getFacetContextProviders() {
        if (this.myFacetContextProvider == null) {
            this.myFacetContextProvider = new ArrayList<FacetContextProvider>();
            this.collectFacetContextProviders(this.myFacetContextProvider);
        }
        return this.myFacetContextProvider;
    }

    protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
        facetContextProvider.add(new JavaeeAppFacetContextProvider());
    }

    @Nullable
    public VirtualFile findSourceFile(@NotNull J2EEServerInstance serverInstance, @NotNull CommonModel model, @NotNull Url url) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "findSourceFile"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "findSourceFile"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "findSourceFile"));
        }
        return null;
    }

    @Deprecated
    @Nullable
    public VirtualFile findSourceFile(@NotNull J2EEServerInstance serverInstance, @NotNull CommonModel model, @NotNull String url) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "findSourceFile"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "findSourceFile"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "findSourceFile"));
        }
        return null;
    }

    @Override
    @Nullable
    public String getUrlForDeployedFile(J2EEServerInstance serverInstance, DeploymentModel deploymentModel, String relativePath) {
        return null;
    }

    public String getUrlForDeployedFile(J2EEServerInstance serverInstance, DeploymentModel deploymentModel) {
        return this.doGetUrlForDeployedFile(serverInstance, deploymentModel, null, null);
    }

    @Nullable
    public String getUrlForDeployedFile(@NotNull J2EEServerInstance serverInstance, @NotNull DeploymentModel deploymentModel, @NotNull JavaeeFacet javaeeFacet, @NotNull String relativePath) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getUrlForDeployedFile"));
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getUrlForDeployedFile"));
        }
        if (javaeeFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacet", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getUrlForDeployedFile"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getUrlForDeployedFile"));
        }
        return this.doGetUrlForDeployedFile(serverInstance, deploymentModel, javaeeFacet, relativePath);
    }

    public void startTrackingServerInstance(@NotNull J2EEServerInstance serverInstance) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "startTrackingServerInstance"));
        }
        this.myServerInstance2Mapping.put(serverInstance, new ServerInstanceMapping());
    }

    public void stopTrackingServerInstance(@NotNull J2EEServerInstance serverInstance) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "stopTrackingServerInstance"));
        }
        this.myServerInstance2Mapping.remove(serverInstance);
    }

    public void updateDeploymentContexts(@NotNull J2EEServerInstance serverInstance, @NotNull DeploymentModel deploymentModel, boolean deployed) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "updateDeploymentContexts"));
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "updateDeploymentContexts"));
        }
        ServerInstanceMapping serverInstanceMapping = this.myServerInstance2Mapping.get(serverInstance);
        if (serverInstanceMapping == null) {
            return;
        }
        if (deployed) {
            serverInstanceMapping.put(deploymentModel, this.getContextsForUnknownFacet(deploymentModel, false));
        } else {
            serverInstanceMapping.remove(deploymentModel);
        }
    }

    private String doGetUrlForDeployedFile(@NotNull J2EEServerInstance serverInstance, @NotNull DeploymentModel deploymentModel, @Nullable JavaeeFacet javaeeFacet, @Nullable String relativePath) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "doGetUrlForDeployedFile"));
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "doGetUrlForDeployedFile"));
        }
        ServerInstanceMapping serverInstanceMapping = this.myServerInstance2Mapping.get(serverInstance);
        if (serverInstanceMapping == null) {
            return null;
        }
        DeploymentMapping deploymentMapping = (DeploymentMapping)serverInstanceMapping.get(deploymentModel);
        if (deploymentMapping == null) {
            return null;
        }
        String context = (String)deploymentMapping.get((Object)javaeeFacet);
        return context == null ? null : this.doCreateUrl(serverInstance.getCommonModel(), context, relativePath);
    }

    private DeploymentMapping getContextsForUnknownFacet(final @NotNull DeploymentModel deploymentModel, final boolean defaultOnly) {
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getContextsForUnknownFacet"));
        }
        final DeploymentMapping deploymentMapping = new DeploymentMapping();
        final Artifact artifact = deploymentModel.getArtifact();
        if (artifact == null) {
            String context = ApplicationServerUrlMapping.getProvidedContext(deploymentModel);
            if (context == null) {
                context = this.getFileContext(deploymentModel);
            }
            deploymentMapping.put(DEFAULT_DEPLOYMENT_CONTEXT_KEY, context);
            return deploymentMapping;
        }
        new ReadAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping$2", "run"));
                }
                Project project = deploymentModel.getCommonModel().getProject();
                JavaeeArtifactUtil javaeeArtifactUtil = JavaeeArtifactUtil.getInstance();
                for (FacetContextProvider facetContextProvider : ApplicationServerUrlMapping.this.getFacetContextProviders()) {
                    for (JavaeeFacet javaeeFacet : javaeeArtifactUtil.getFacetsIncludedInArtifact(project, artifact, facetContextProvider.getFacetId())) {
                        String facetContext = ApplicationServerUrlMapping.this.getContextForKnownFacet(deploymentModel, javaeeFacet);
                        if (facetContext == null) continue;
                        deploymentMapping.put(javaeeFacet, facetContext);
                        if (deploymentMapping.containsKey((Object)DEFAULT_DEPLOYMENT_CONTEXT_KEY)) continue;
                        deploymentMapping.put(DEFAULT_DEPLOYMENT_CONTEXT_KEY, facetContext);
                        if (!defaultOnly) continue;
                        return;
                    }
                }
            }
        }.execute();
        return deploymentMapping;
    }

    protected String getFileContext(DeploymentModel deploymentModel) {
        return null;
    }

    protected String doCreateUrl(@NotNull CommonModel serverConfig, @Nullable String context, @Nullable String relativePath) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "doCreateUrl"));
        }
        return ApplicationServerUrlMapping.createUrl(serverConfig, context, relativePath);
    }

    public static String createUrl(@NotNull CommonModel serverConfig, @Nullable String context, @Nullable String relativePath) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "createUrl"));
        }
        String result = "http://" + serverConfig.getHost() + ':' + serverConfig.getPort();
        if (StringUtil.isNotEmpty((String)context)) {
            result = DeploymentUtil.concatPaths((String[])new String[]{result, context});
        }
        result = StringUtil.isNotEmpty((String)relativePath) ? DeploymentUtil.concatPaths((String[])new String[]{result, relativePath}) : DeploymentUtil.concatPaths((String[])new String[]{result, "/"});
        return result;
    }

    public String getDefaultUrlForServerConfig(@NotNull CommonModel serverConfig) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getDefaultUrlForServerConfig"));
        }
        for (DeploymentModel deploymentModel : serverConfig.getDeploymentModels()) {
            DeploymentMapping deploymentMapping = this.getContextsForUnknownFacet(deploymentModel, true);
            String context = (String)deploymentMapping.get(null);
            if (context == null) continue;
            return this.doCreateUrl(serverConfig, context, null);
        }
        return this.doCreateUrl(serverConfig, null, null);
    }

    private String getContextForKnownFacet(final @NotNull DeploymentModel deploymentModel, final @NotNull JavaeeFacet javaeeFacet) {
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getContextForKnownFacet"));
        }
        if (javaeeFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacet", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getContextForKnownFacet"));
        }
        String providedContext = ApplicationServerUrlMapping.getProvidedContext(deploymentModel);
        if (providedContext != null) {
            return providedContext;
        }
        return (String)new ReadAction<String>(){

            protected void run(@NotNull Result<String> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping$3", "run"));
                }
                FacetTypeId facetTypeId = javaeeFacet.getTypeId();
                for (FacetContextProvider facetContextProvider : ApplicationServerUrlMapping.this.getFacetContextProviders()) {
                    if (!facetContextProvider.getFacetId().equals((Object)facetTypeId)) continue;
                    result.setResult((Object)facetContextProvider.getDeploymentContext(ApplicationServerUrlMapping.this.getWebModuleContextProviders(), deploymentModel, javaeeFacet));
                    return;
                }
            }
        }.execute().getResultObject();
    }

    @Nullable
    private static String getProvidedContext(@NotNull DeploymentModel deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/javaee/appServerIntegrations/ApplicationServerUrlMapping", "getProvidedContext"));
        }
        if (!(deployment instanceof DeploymentModelContext)) {
            return null;
        }
        DeploymentModelContext contextProvider = (DeploymentModelContext)((Object)deployment);
        return contextProvider.isDefaultContextRoot() ? null : contextProvider.getContextRoot();
    }

    private static class DeploymentMapping
    extends HashMap<JavaeeFacet, String> {
        private DeploymentMapping() {
        }
    }

    private static class ServerInstanceMapping
    extends HashMap<DeploymentModel, DeploymentMapping> {
        private ServerInstanceMapping() {
        }
    }
}

