/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.xml.ModuleContextProvider;
import org.jetbrains.annotations.NotNull;

public class JavaeeModuleContextProvider
extends ModuleContextProvider {
    @NotNull
    public Module[] getContextModules(@NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/module/JavaeeModuleContextProvider", "getContextModules"));
        }
        Project project = context.getProject();
        HashSet modules = new HashSet();
        for (JavaeeFacet javaeeFacet : JavaeeFacetUtil.getInstance().getAllJavaeeFacets(project)) {
            ConfigFileContainer descriptorsContainer = javaeeFacet.getDescriptorsContainer();
            if (descriptorsContainer == null) continue;
            for (ConfigFile file : descriptorsContainer.getConfigFiles()) {
                if (!context.equals(file.getPsiFile())) continue;
                modules.add(javaeeFacet.getModule());
            }
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/JavaeeModuleContextProvider", "getContextModules"));
        }
        return moduleArray;
    }
}

