/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public enum ServletMappingType {
    EXTENSION{

        @Override
        public ServletMappingInfo createMappingInfo(@NotNull String urlPattern, @NotNull CommonServletMapping mapping) {
            if (urlPattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPattern", "com/intellij/javaee/web/ServletMappingType$1", "createMappingInfo"));
            }
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/javaee/web/ServletMappingType$1", "createMappingInfo"));
            }
            return new ServletMappingInfo.ExtensionMappingInfo(urlPattern, mapping);
        }
    }
    ,
    PATH{

        @Override
        public ServletMappingInfo createMappingInfo(@NotNull String urlPattern, @NotNull CommonServletMapping mapping) {
            if (urlPattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPattern", "com/intellij/javaee/web/ServletMappingType$2", "createMappingInfo"));
            }
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/javaee/web/ServletMappingType$2", "createMappingInfo"));
            }
            return new ServletMappingInfo.PathMappingInfo(urlPattern, mapping);
        }
    }
    ,
    DEFAULT{

        @Override
        public ServletMappingInfo createMappingInfo(@NotNull String urlPattern, @NotNull CommonServletMapping mapping) {
            if (urlPattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPattern", "com/intellij/javaee/web/ServletMappingType$3", "createMappingInfo"));
            }
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/javaee/web/ServletMappingType$3", "createMappingInfo"));
            }
            return new ServletMappingInfo.DefaultMappingInfo(urlPattern, mapping);
        }
    }
    ,
    EXACT{

        @Override
        public ServletMappingInfo createMappingInfo(@NotNull String urlPattern, @NotNull CommonServletMapping mapping) {
            if (urlPattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPattern", "com/intellij/javaee/web/ServletMappingType$4", "createMappingInfo"));
            }
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/javaee/web/ServletMappingType$4", "createMappingInfo"));
            }
            return new ServletMappingInfo.ExactMappingInfo(urlPattern, mapping);
        }
    };


    public abstract ServletMappingInfo createMappingInfo(@NotNull String var1, @NotNull CommonServletMapping var2);

    @NotNull
    public static ServletMappingType getPatternType(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/javaee/web/ServletMappingType", "getPatternType"));
        }
        if (pattern.equals("/")) {
            ServletMappingType servletMappingType = DEFAULT;
            if (servletMappingType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingType", "getPatternType"));
            }
            return servletMappingType;
        }
        if (pattern.startsWith("*.")) {
            ServletMappingType servletMappingType = EXTENSION;
            if (servletMappingType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingType", "getPatternType"));
            }
            return servletMappingType;
        }
        if (StringUtil.startsWithChar((CharSequence)pattern, (char)'/') && pattern.endsWith("/*")) {
            ServletMappingType servletMappingType = PATH;
            if (servletMappingType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingType", "getPatternType"));
            }
            return servletMappingType;
        }
        ServletMappingType servletMappingType = EXACT;
        if (servletMappingType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingType", "getPatternType"));
        }
        return servletMappingType;
    }
}

