/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JpaCommonUtil {
    private JpaCommonUtil() {
    }

    public static GlobalSearchScope getORMClassesSearchScope(@NotNull Project project, Module module, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/util/JpaCommonUtil", "getORMClassesSearchScope"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jpa/util/JpaCommonUtil", "getORMClassesSearchScope"));
        }
        ProjectRootManager instance = ProjectRootManager.getInstance((Project)project);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !instance.getFileIndex().isInLibraryClasses(virtualFile) || !virtualFile.getFileSystem().isReadOnly()) {
            return module == null ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        }
        final ArrayList files = new ArrayList();
        for (OrderEntry entry : instance.getFileIndex().getOrderEntriesForFile(virtualFile)) {
            if (module != null && !entry.getOwnerModule().equals(module)) continue;
            ContainerUtil.addAll(files, (Object[])entry.getFiles(OrderRootType.CLASSES));
        }
        final GlobalSearchScope base = module == null ? ProjectScope.getAllScope((Project)project) : module.getModuleWithLibrariesScope();
        return new GlobalSearchScope(project){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/util/JpaCommonUtil$1", "contains"));
                }
                for (VirtualFile file1 : files) {
                    if (!VfsUtil.isAncestor((VirtualFile)file1, (VirtualFile)file, (boolean)true)) continue;
                    return true;
                }
                return false;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/jpa/util/JpaCommonUtil$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/jpa/util/JpaCommonUtil$1", "compare"));
                }
                return base.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/jpa/util/JpaCommonUtil$1", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }
}

